/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.aggregates.DLPDomainConfiguration;
import org.apache.james.dlp.eventsourcing.commands.ClearCommand;
import org.apache.james.dlp.eventsourcing.commands.ClearCommandHandler;
import org.apache.james.dlp.eventsourcing.commands.StoreCommand;
import org.apache.james.dlp.eventsourcing.commands.StoreCommandHandler;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;

public class EventSourcingDLPConfigurationStore
implements DLPConfigurationStore {
    private static final ImmutableSet<Subscriber> NO_SUBSCRIBER = ImmutableSet.of();
    private final EventSourcingSystem eventSourcingSystem;
    private final EventStore eventStore;

    @Inject
    public EventSourcingDLPConfigurationStore(EventStore eventStore) {
        this.eventSourcingSystem = new EventSourcingSystem((Set)ImmutableSet.of((Object)new ClearCommandHandler(eventStore), (Object)new StoreCommandHandler(eventStore)), NO_SUBSCRIBER, eventStore);
        this.eventStore = eventStore;
    }

    public Stream<DLPConfigurationItem> list(Domain domain) {
        DLPAggregateId aggregateId = new DLPAggregateId(domain);
        return DLPDomainConfiguration.load(aggregateId, this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).retrieveRules();
    }

    public void store(Domain domain, List<DLPConfigurationItem> rules) {
        this.eventSourcingSystem.dispatch((Command)new StoreCommand(domain, rules));
    }

    public void clear(Domain domain) {
        this.eventSourcingSystem.dispatch((Command)new ClearCommand(domain));
    }
}

