/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfigurationProvider.class);
    private static final String CONFIGURATION_FILE_SUFFIX = ".xml";
    private static final char SEMICOLON = ';';
    public static final HierarchicalConfiguration EMTY_CONFIGURATION = new HierarchicalConfiguration();
    private final FileSystem fileSystem;
    private final String configurationPrefix;

    public static XMLConfiguration getConfig(InputStream configStream) throws ConfigurationException {
        XMLConfiguration.setDefaultListDelimiter((char)';');
        XMLConfiguration config = new XMLConfiguration();
        config.setDelimiterParsingDisabled(true);
        config.setAttributeSplittingDisabled(true);
        config.load(configStream);
        return config;
    }

    public FileConfigurationProvider(FileSystem fileSystem, Configuration configuration) {
        this.fileSystem = fileSystem;
        this.configurationPrefix = configuration.configurationPath();
    }

    @Override
    public HierarchicalConfiguration getConfiguration(String component) throws ConfigurationException {
        Preconditions.checkNotNull((Object)component);
        List configPathParts = Splitter.on((String)".").splitToList((CharSequence)component);
        Preconditions.checkArgument((!configPathParts.isEmpty() ? 1 : 0) != 0);
        Optional<InputStream> inputStream = this.retrieveConfigInputStream((String)configPathParts.get(0));
        if (inputStream.isPresent()) {
            return this.selectConfigurationPart(configPathParts, (HierarchicalConfiguration)FileConfigurationProvider.getConfig(inputStream.get()));
        }
        return EMTY_CONFIGURATION;
    }

    private HierarchicalConfiguration selectConfigurationPart(List<String> configPathParts, HierarchicalConfiguration config) {
        return this.selectHierarchicalConfigPart(config, Iterables.skip(configPathParts, (int)1));
    }

    private Optional<InputStream> retrieveConfigInputStream(String configurationFileWithoutExtension) throws ConfigurationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationFileWithoutExtension) ? 1 : 0) != 0, (Object)"The configuration file name should not be empty or null");
        try {
            return Optional.of(this.fileSystem.getResource(this.configurationPrefix + configurationFileWithoutExtension + CONFIGURATION_FILE_SUFFIX));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to locate configuration file {}.xml, assuming empty configuration", (Object)configurationFileWithoutExtension);
            return Optional.empty();
        }
    }

    private HierarchicalConfiguration selectHierarchicalConfigPart(HierarchicalConfiguration config, Iterable<String> configsPathParts) {
        HierarchicalConfiguration currentConfig = config;
        for (String nextPathPart : configsPathParts) {
            currentConfig = currentConfig.configurationAt(nextPathPart);
        }
        return currentConfig;
    }
}

