/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.InternetHeadersInputStream;
import org.apache.james.server.core.MailHeaders;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageUtil;

public class MimeMessageWrapper
extends MimeMessage
implements Disposable {
    public static final String USE_MEMORY_COPY = "james.message.usememorycopy";
    protected MimeMessageSource source = null;
    protected boolean messageParsed = false;
    protected boolean headersModified = false;
    protected boolean bodyModified = false;
    private InputStream sourceIn;
    private long initialHeaderSize;

    private MimeMessageWrapper(Session session) {
        super(session);
        this.headers = null;
        this.modified = false;
        this.headersModified = false;
        this.bodyModified = false;
    }

    public MimeMessageWrapper(Session session, MimeMessageSource source) {
        this(session);
        this.source = source;
    }

    public MimeMessageWrapper(MimeMessageSource source) {
        this(Session.getDefaultInstance((Properties)System.getProperties()), source);
    }

    public MimeMessageWrapper(MimeMessage original) throws MessagingException {
        this(Session.getDefaultInstance((Properties)System.getProperties()));
        this.flags = original.getFlags();
        if (this.source == null) {
            boolean useMemoryCopy = false;
            String memoryCopy = System.getProperty(USE_MEMORY_COPY);
            if (memoryCopy != null) {
                useMemoryCopy = Boolean.valueOf(memoryCopy);
            }
            try {
                if (useMemoryCopy) {
                    int size = original.getSize();
                    ByteArrayOutputStream bos = size > 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream();
                    original.writeTo((OutputStream)bos);
                    bos.close();
                    SharedByteArrayInputStream in = new SharedByteArrayInputStream(bos.toByteArray());
                    this.parse((InputStream)in);
                    in.close();
                    this.saved = true;
                } else {
                    MimeMessageInputStreamSource src = new MimeMessageInputStreamSource("MailCopy-" + UUID.randomUUID().toString());
                    OutputStream out = src.getWritableOutputStream();
                    original.writeTo(out);
                    out.close();
                    this.source = src;
                }
            }
            catch (IOException ex) {
                throw new MessagingException("IOException while copying message", (Exception)ex);
            }
        }
    }

    protected void updateMessageID() throws MessagingException {
        if (this.getMessageID() == null) {
            super.updateMessageID();
        }
    }

    public synchronized String getSourceId() {
        return this.source != null ? this.source.getSourceId() : null;
    }

    protected synchronized void loadHeaders() throws MessagingException {
        block7: {
            if (this.headers == null) {
                if (this.source != null) {
                    try {
                        InputStream in = this.source.getInputStream();
                        try {
                            this.headers = this.createInternetHeaders(in);
                            break block7;
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)in);
                        }
                    }
                    catch (IOException ioe) {
                        throw new MessagingException("Unable to parse headers from stream: " + ioe.getMessage(), (Exception)ioe);
                    }
                }
                throw new MessagingException("loadHeaders called for a message with no source, contentStream or stream");
            }
        }
    }

    public synchronized void loadMessage() throws MessagingException {
        if (!this.messageParsed) {
            if (this.source != null) {
                this.sourceIn = null;
                try {
                    this.sourceIn = this.source.getInputStream();
                    this.parse(this.sourceIn);
                    this.saved = true;
                }
                catch (IOException ioe) {
                    IOUtils.closeQuietly((InputStream)this.sourceIn);
                    this.sourceIn = null;
                    throw new MessagingException("Unable to parse stream: " + ioe.getMessage(), (Exception)ioe);
                }
            } else {
                throw new MessagingException("loadHeaders called for an unparsed message with no source");
            }
        }
    }

    public synchronized boolean isModified() {
        return this.headersModified || this.bodyModified || this.modified;
    }

    public synchronized boolean isBodyModified() {
        return this.bodyModified;
    }

    public synchronized boolean isHeaderModified() {
        return this.headersModified;
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        this.writeTo(os, os);
    }

    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        this.writeTo(os, os, ignoreList);
    }

    public void writeTo(OutputStream headerOs, OutputStream bodyOs) throws IOException, MessagingException {
        this.writeTo(headerOs, bodyOs, new String[0]);
    }

    public void writeTo(OutputStream headerOs, OutputStream bodyOs, String[] ignoreList) throws IOException, MessagingException {
        this.writeTo(headerOs, bodyOs, ignoreList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeTo(OutputStream headerOs, OutputStream bodyOs, String[] ignoreList, boolean preLoad) throws IOException, MessagingException {
        if (!preLoad && this.source != null && !this.isBodyModified()) {
            InputStream in = this.source.getInputStream();
            try {
                MailHeaders myHeaders;
                MailHeaders parsedHeaders = new MailHeaders(in);
                if (!this.isHeaderModified()) {
                    myHeaders = parsedHeaders;
                } else {
                    if (!this.saved) {
                        this.saveChanges();
                    }
                    myHeaders = this.headers;
                }
                Enumeration filteredHeaders = myHeaders.getNonMatchingHeaderLines(ignoreList);
                IOUtils.copy((InputStream)new InternetHeadersInputStream(filteredHeaders), (OutputStream)headerOs);
                IOUtils.copy((InputStream)in, (OutputStream)bodyOs);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            if (!this.saved) {
                this.saveChanges();
            }
            if (this.headers == null) {
                this.loadHeaders();
            }
            Enumeration filteredHeaders = this.headers.getNonMatchingHeaderLines(ignoreList);
            IOUtils.copy((InputStream)new InternetHeadersInputStream(filteredHeaders), (OutputStream)headerOs);
            if (preLoad && !this.messageParsed) {
                this.loadMessage();
            }
            MimeMessageUtil.writeMessageBodyTo(this, bodyOs);
        }
    }

    public synchronized int getSize() throws MessagingException {
        if (this.source != null) {
            try {
                long fullSize = this.source.getMessageSize();
                if (this.headers == null) {
                    this.loadHeaders();
                }
                return (int)(fullSize - this.initialHeaderSize - 2L);
            }
            catch (IOException e) {
                throw new MessagingException("Unable to calculate message size");
            }
        }
        if (!this.messageParsed) {
            this.loadMessage();
        }
        return super.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount() throws MessagingException {
        int n;
        InputStream in;
        try {
            in = this.getContentStream();
        }
        catch (Exception e) {
            return -1;
        }
        if (in == null) {
            return -1;
        }
        InputStreamReader isr = null;
        LineNumberReader counter = null;
        try {
            if (this.getEncoding() != null) {
                isr = new InputStreamReader(in, this.getEncoding());
                counter = new LineNumberReader(isr);
            } else {
                isr = new InputStreamReader(in);
                counter = new LineNumberReader(isr);
            }
            char[] block = new char[4096];
            while (counter.read(block) > -1) {
            }
            n = counter.getLineNumber();
        }
        catch (IOException ioe) {
            int n2;
            try {
                n2 = -1;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(counter);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            IOUtils.closeQuietly(counter);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)in);
            return n2;
        }
        IOUtils.closeQuietly((Reader)counter);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)in);
        return n;
    }

    public long getMessageSize() throws MessagingException {
        if (this.source != null && !this.isModified()) {
            try {
                return this.source.getMessageSize();
            }
            catch (IOException ioe) {
                throw new MessagingException("Error retrieving message size", (Exception)ioe);
            }
        }
        return MimeMessageUtil.calculateMessageSize(this);
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name, delimiter);
    }

    public Enumeration<Header> getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public Enumeration<Header> getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration<Header> getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(names);
    }

    public Enumeration<String> getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration<String> getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration<String> getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(names);
    }

    private synchronized void checkModifyHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        this.modified = true;
        this.saved = false;
        this.headersModified = true;
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.checkModifyHeaders();
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.checkModifyHeaders();
        super.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.checkModifyHeaders();
        super.removeHeader(name);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.checkModifyHeaders();
        super.addHeaderLine(line);
    }

    public synchronized void setDataHandler(DataHandler arg0) throws MessagingException {
        this.modified = true;
        this.saved = false;
        this.bodyModified = true;
        super.setDataHandler(arg0);
    }

    public void dispose() {
        if (this.sourceIn != null) {
            IOUtils.closeQuietly((InputStream)this.sourceIn);
        }
        if (this.source != null) {
            LifecycleUtil.dispose((Object)this.source);
        }
    }

    protected synchronized void parse(InputStream is) throws MessagingException {
        super.parse(is);
        this.messageParsed = true;
    }

    protected synchronized InternetHeaders createInternetHeaders(InputStream is) throws MessagingException {
        MailHeaders newHeaders = new MailHeaders(is);
        if (this.headers != null) {
            return this.headers;
        }
        this.initialHeaderSize = newHeaders.getSize();
        return newHeaders;
    }

    protected InputStream getContentStream() throws MessagingException {
        if (!this.messageParsed) {
            this.loadMessage();
        }
        return super.getContentStream();
    }

    public synchronized InputStream getRawInputStream() throws MessagingException {
        if (!this.messageParsed && !this.isModified() && this.source != null) {
            try {
                InputStream is = this.source.getInputStream();
                new MailHeaders(is);
                return is;
            }
            catch (IOException e) {
                throw new MessagingException("Unable to read the stream", (Exception)e);
            }
        }
        return super.getRawInputStream();
    }

    public synchronized InputStream getMessageInputStream() throws MessagingException {
        if (!this.messageParsed && !this.isModified() && this.source != null) {
            try {
                return this.source.getInputStream();
            }
            catch (IOException e) {
                throw new MessagingException("Unable to get inputstream", (Exception)e);
            }
        }
        try {
            if (!this.bodyModified && this.source != null) {
                InputStream in = this.source.getInputStream();
                new MailHeaders(in);
                return new SequenceInputStream(new InternetHeadersInputStream(this.getAllHeaderLines()), in);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeTo(out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            throw new MessagingException("Unable to get inputstream", (Exception)e);
        }
    }
}

