/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Chars;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.server.core.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailImpl
implements Disposable,
Mail {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailImpl.class);
    public static final long serialVersionUID = -4289663364703986260L;
    private String errorMessage;
    private String state;
    private MimeMessageCopyOnWriteProxy message;
    private MailAddress sender;
    private Collection<MailAddress> recipients;
    private String name;
    private String remoteHost = "localhost";
    private String remoteAddr = "127.0.0.1";
    private Date lastUpdated = new Date();
    private Map<String, Object> attributes;
    private PerRecipientHeaders perRecipientSpecificHeaders;

    public static MailImpl duplicate(Mail mail) throws MessagingException {
        return new MailImpl(mail, MailImpl.deriveNewName(mail.getName()));
    }

    public static MailImpl fromMimeMessage(String name, MimeMessage mimeMessage) throws MessagingException {
        MailAddress sender = MailImpl.getSender(mimeMessage);
        ImmutableList<MailAddress> recipients = MailImpl.getRecipients(mimeMessage);
        return new MailImpl(name, sender, (Collection<MailAddress>)recipients, mimeMessage);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ImmutableList<MailAddress> getRecipients(MimeMessage mimeMessage) throws MessagingException {
        return (ImmutableList)Arrays.stream(mimeMessage.getAllRecipients()).map(Throwing.function(MailImpl::castToMailAddress).sneakyThrow()).collect(Guavate.toImmutableList());
    }

    private static MailAddress getSender(MimeMessage mimeMessage) throws MessagingException {
        Address[] sender = mimeMessage.getFrom();
        Preconditions.checkArgument((sender.length == 1 ? 1 : 0) != 0);
        return MailImpl.castToMailAddress(sender[0]);
    }

    private static MailAddress castToMailAddress(Address address) throws AddressException {
        Preconditions.checkArgument((boolean)(address instanceof InternetAddress));
        return new MailAddress((InternetAddress)address);
    }

    @VisibleForTesting
    static String deriveNewName(String currentName) throws MessagingException {
        char separator = '!';
        int loopThreshold = 7;
        int suffixLength = 9;
        int suffixMaxLength = loopThreshold * suffixLength;
        int nameMaxLength = suffixMaxLength + 13;
        MailImpl.detectPossibleLoop(currentName, loopThreshold, separator);
        String newName = currentName + MailImpl.generateRandomSuffix(suffixLength, separator);
        return MailImpl.stripFirstCharsIfNeeded(nameMaxLength, newName);
    }

    private static String stripFirstCharsIfNeeded(int nameMaxLength, String newName) {
        return newName.substring(Math.max(0, newName.length() - nameMaxLength));
    }

    private static String generateRandomSuffix(int suffixLength, char separator) {
        return "-" + separator + RandomStringUtils.randomNumeric((int)(suffixLength - 2));
    }

    private static void detectPossibleLoop(String currentName, int loopThreshold, char separator) throws MessagingException {
        long occurrences = currentName.chars().filter(c -> Chars.saturatedCast((long)c) == separator).count();
        if (occurrences > (long)loopThreshold) {
            throw new MessagingException("Unable to create a new message name: too long. Possible loop in config.xml.");
        }
    }

    public MailImpl() {
        this.setState("root");
        this.attributes = new HashMap<String, Object>();
        this.perRecipientSpecificHeaders = new PerRecipientHeaders();
        this.recipients = null;
    }

    public MailImpl(String name, MailAddress sender, Collection<MailAddress> recipients) {
        this();
        this.setName(name);
        this.setSender(sender);
        if (recipients != null) {
            this.setRecipients(recipients);
        }
    }

    private MailImpl(Mail mail, String newName) throws MessagingException {
        this(newName, mail.getSender(), (Collection<MailAddress>)mail.getRecipients(), mail.getMessage());
        this.setRemoteHost(mail.getRemoteHost());
        this.setRemoteAddr(mail.getRemoteAddr());
        this.setLastUpdated(mail.getLastUpdated());
        this.setErrorMessage(mail.getErrorMessage());
        try {
            if (mail instanceof MailImpl) {
                this.setAttributesRaw((HashMap)MailImpl.cloneSerializableObject(((MailImpl)mail).getAttributesRaw()));
            } else {
                HashMap<String, Object> attribs = new HashMap<String, Object>();
                Iterator i = mail.getAttributeNames();
                while (i.hasNext()) {
                    String hashKey = (String)i.next();
                    attribs.put(hashKey, MailImpl.cloneSerializableObject(mail.getAttribute(hashKey)));
                }
                this.setAttributesRaw(attribs);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Error while deserializing attributes", (Throwable)e);
            this.setAttributesRaw(new HashMap<String, Object>());
        }
    }

    public MailImpl(String name, MailAddress sender, Collection<MailAddress> recipients, InputStream messageIn) throws MessagingException {
        this(name, sender, recipients);
        MimeMessageInputStreamSource source = new MimeMessageInputStreamSource(name, messageIn);
        try {
            this.setMessage(new MimeMessageCopyOnWriteProxy(source));
        }
        catch (MessagingException e) {
            LifecycleUtil.dispose((Object)source);
            throw e;
        }
    }

    public MailImpl(String name, MailAddress sender, Collection<MailAddress> recipients, MimeMessage message) throws MessagingException {
        this(name, sender, recipients);
        this.setMessage(new MimeMessageCopyOnWriteProxy(message));
    }

    @VisibleForTesting
    Mail duplicate(String newName) {
        try {
            return new MailImpl(this, newName);
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MimeMessage getMessage() throws MessagingException {
        return this.message;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<MailAddress> getRecipients() {
        return this.recipients;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public String getState() {
        return this.state;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public long getMessageSize() throws MessagingException {
        return MimeMessageUtil.getMessageSize(this.message);
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public void setMessage(MimeMessage message) throws MessagingException {
        if (this.message != message) {
            if (this.message != null) {
                LifecycleUtil.dispose((Object)((Object)this.message));
            }
            this.message = message instanceof MimeMessageCopyOnWriteProxy ? (MimeMessageCopyOnWriteProxy)message : new MimeMessageCopyOnWriteProxy(message);
        }
    }

    public void setRecipients(Collection<MailAddress> recipients) {
        this.recipients = ImmutableList.copyOf(recipients);
    }

    public void setSender(MailAddress sender) {
        this.sender = sender;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setLastUpdated(Date lastUpdated) {
        if (lastUpdated != null) {
            lastUpdated = new Date(lastUpdated.getTime());
        }
        this.lastUpdated = lastUpdated;
    }

    public void writeMessageTo(OutputStream out) throws IOException, MessagingException {
        if (this.message == null) {
            throw new MessagingException("No message set for this MailImpl.");
        }
        this.message.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Object obj = in.readObject();
            if (obj == null) {
                this.sender = null;
            } else if (obj instanceof String) {
                this.sender = new MailAddress((String)obj);
            } else if (obj instanceof MailAddress) {
                this.sender = (MailAddress)obj;
            }
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing sender address: " + pe.getMessage());
        }
        this.recipients = (Collection)in.readObject();
        this.state = (String)in.readObject();
        this.errorMessage = (String)in.readObject();
        this.name = (String)in.readObject();
        this.remoteHost = (String)in.readObject();
        this.remoteAddr = (String)in.readObject();
        this.setLastUpdated((Date)in.readObject());
        try {
            this.attributes = (HashMap)in.readObject();
        }
        catch (OptionalDataException ode) {
            if (ode.eof) {
                this.attributes = new HashMap<String, Object>();
            }
            throw ode;
        }
        this.perRecipientSpecificHeaders = (PerRecipientHeaders)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.sender);
        out.writeObject(this.recipients);
        out.writeObject(this.state);
        out.writeObject(this.errorMessage);
        out.writeObject(this.name);
        out.writeObject(this.remoteHost);
        out.writeObject(this.remoteAddr);
        out.writeObject(this.lastUpdated);
        out.writeObject(this.attributes);
        out.writeObject(this.perRecipientSpecificHeaders);
    }

    public void dispose() {
        LifecycleUtil.dispose((Object)((Object)this.message));
        this.message = null;
    }

    public Map<String, Object> getAttributesRaw() {
        return this.attributes;
    }

    public void setAttributesRaw(HashMap<String, Object> attr) {
        this.attributes = attr == null ? new HashMap() : attr;
    }

    public Serializable getAttribute(String key) {
        return (Serializable)this.attributes.get(key);
    }

    public Serializable setAttribute(String key, Serializable object) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of an attribute should not be null");
        return (Serializable)this.attributes.put(key, object);
    }

    public Serializable removeAttribute(String key) {
        return (Serializable)this.attributes.remove(key);
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    private static Object cloneSerializableObject(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(b);
        out.writeObject(o);
        out.flush();
        out.close();
        ByteArrayInputStream bi = new ByteArrayInputStream(b.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bi);
        return in.readObject();
    }

    public static String getId() {
        return "Mail" + System.currentTimeMillis() + "-" + UUID.randomUUID();
    }

    public PerRecipientHeaders getPerRecipientSpecificHeaders() {
        return this.perRecipientSpecificHeaders;
    }

    public void addSpecificHeaderForRecipient(PerRecipientHeaders.Header header, MailAddress recipient) {
        this.perRecipientSpecificHeaders.addHeaderForRecipient(header, recipient);
    }

    public void addAllSpecificHeaderForRecipient(PerRecipientHeaders perRecipientHeaders) {
        this.perRecipientSpecificHeaders.addAll(perRecipientHeaders);
    }

    public static class Builder {
        private Optional<MimeMessage> mimeMessage = Optional.empty();
        private List<MailAddress> recipients = Lists.newArrayList();
        private Optional<String> name = Optional.empty();
        private Optional<MailAddress> sender = Optional.empty();
        private Optional<String> state = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Optional<Date> lastUpdated = Optional.empty();
        private Map<String, Serializable> attributes = Maps.newHashMap();
        private Optional<String> remoteAddr = Optional.empty();
        private Optional<String> remoteHost = Optional.empty();
        private PerRecipientHeaders perRecipientHeaders = new PerRecipientHeaders();

        private Builder() {
        }

        public Builder mimeMessage(MimeMessage mimeMessage) {
            this.mimeMessage = Optional.ofNullable(mimeMessage);
            return this;
        }

        public Builder mimeMessage(MimeMessageBuilder mimeMessage) throws MessagingException {
            this.mimeMessage = Optional.ofNullable(mimeMessage.build());
            return this;
        }

        public Builder recipients() {
            return this;
        }

        public Builder recipients(List<MailAddress> recipients) {
            this.recipients.addAll(recipients);
            return this;
        }

        public Builder recipients(MailAddress ... recipients) {
            return this.recipients((List<MailAddress>)ImmutableList.copyOf((Object[])recipients));
        }

        public Builder recipients(String ... recipients) {
            return this.recipients((List)Arrays.stream(recipients).map(Throwing.function(MailAddress::new)).collect(Guavate.toImmutableList()));
        }

        public Builder recipient(MailAddress recipient) {
            return this.recipients(recipient);
        }

        public Builder recipient(String recipient) throws AddressException {
            return this.recipients(recipient);
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder sender(MailAddress sender) {
            this.sender = Optional.ofNullable(sender);
            return this;
        }

        public Builder sender(String sender) throws AddressException {
            return this.sender(new MailAddress(sender));
        }

        public Builder state(String state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        public Builder lastUpdated(Date lastUpdated) {
            this.lastUpdated = Optional.ofNullable(lastUpdated);
            return this;
        }

        public Builder attribute(String name, Serializable object) {
            this.attributes.put(name, object);
            return this;
        }

        public Builder attributes(Map<String, Serializable> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = Optional.ofNullable(remoteAddr);
            return this;
        }

        public Builder remoteHost(String remoteHost) {
            this.remoteHost = Optional.ofNullable(remoteHost);
            return this;
        }

        public Builder addHeaderForRecipient(PerRecipientHeaders.Header header, MailAddress recipient) {
            this.perRecipientHeaders.addHeaderForRecipient(header, recipient);
            return this;
        }

        public Builder addAllHeadersForRecipients(PerRecipientHeaders perRecipientHeaders) {
            this.perRecipientHeaders.addAll(perRecipientHeaders);
            return this;
        }

        public MailImpl build() {
            MailImpl mail = new MailImpl();
            this.mimeMessage.ifPresent(Throwing.consumer(mail::setMessage).sneakyThrow());
            this.name.ifPresent(mail::setName);
            this.sender.ifPresent(mail::setSender);
            mail.setRecipients(this.recipients);
            this.state.ifPresent(mail::setState);
            this.errorMessage.ifPresent(mail::setErrorMessage);
            this.lastUpdated.ifPresent(mail::setLastUpdated);
            mail.setAttributesRaw(new HashMap<String, Object>(this.attributes));
            this.remoteAddr.ifPresent(mail::setRemoteAddr);
            this.remoteHost.ifPresent(mail::setRemoteHost);
            mail.perRecipientSpecificHeaders.addAll(this.perRecipientHeaders);
            return mail;
        }
    }
}

