/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.hbase;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Splitter;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.hbase.def.HRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.system.hbase.TablePool;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private static final Logger log = LoggerFactory.getLogger((String)HBaseRecipientRewriteTable.class.getName());
    private static final String ROW_SEPARATOR = "@";
    private static final String COLUMN_SEPARATOR = ";";

    public void addMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings map = this.getUserDomainMappings(source);
        if (!map.isEmpty()) {
            MappingsImpl updatedMappings = MappingsImpl.from((Mappings)map).add(mapping).build();
            this.doUpdateMapping(source, updatedMappings.serialize());
        } else {
            this.doAddMapping(source, mapping.asString());
        }
    }

    public Mappings getUserDomainMappings(MappingSource source) throws RecipientRewriteTableException {
        HTableInterface table = null;
        MappingsImpl list = MappingsImpl.empty();
        try {
            table = TablePool.getInstance().getRecipientRewriteTable();
            Mappings mappings = this.feedUserDomainMappingsList(table, source, (Mappings)list);
            return mappings;
        }
        catch (IOException e) {
            log.error("Error while getting user domain mapping in HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while getting user domain mapping in HBase", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    private Mappings feedUserDomainMappingsList(HTableInterface table, MappingSource source, Mappings list) throws IOException {
        Get get = new Get(Bytes.toBytes((String)this.getRowKey(source)));
        Result result = table.get(get);
        List keyValues = result.getColumn(HRecipientRewriteTable.COLUMN_FAMILY_NAME, HRecipientRewriteTable.COLUMN.MAPPING);
        if (keyValues.size() > 0) {
            return MappingsImpl.from((Mappings)list).addAll((Mappings)MappingsImpl.fromRawString((String)Bytes.toString((byte[])((KeyValue)keyValues.get(0)).getValue()))).build();
        }
        return list;
    }

    public Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException {
        HTableInterface table = null;
        ResultScanner resultScanner = null;
        HashMap<MappingSource, Mappings> map = new HashMap<MappingSource, Mappings>();
        try {
            Result result;
            table = TablePool.getInstance().getRecipientRewriteTable();
            Scan scan = new Scan();
            scan.addFamily(HRecipientRewriteTable.COLUMN_FAMILY_NAME);
            scan.setCaching(table.getConfiguration().getInt("hbase.client.scanner.caching", 1) * 2);
            resultScanner = table.getScanner(scan);
            while ((result = resultScanner.next()) != null) {
                List keyValues = result.list();
                if (keyValues == null) continue;
                for (KeyValue keyValue : keyValues) {
                    MappingSource email = MappingSource.parse((String)Bytes.toString((byte[])keyValue.getRow()));
                    MappingsImpl mappings = MappingsImpl.from((Mappings)((Mappings)Optional.ofNullable(map.get(email)).orElse(MappingsImpl.empty()))).addAll(Splitter.on((String)COLUMN_SEPARATOR).split((CharSequence)Bytes.toString((byte[])keyValue.getValue()))).build();
                    map.put(email, (Mappings)mappings);
                }
            }
        }
        catch (IOException e) {
            log.error("Error while getting all mapping from HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while getting all mappings from HBase", (Throwable)e);
        }
        finally {
            if (resultScanner != null) {
                resultScanner.close();
            }
            IOUtils.closeQuietly((Closeable)table);
        }
        return map;
    }

    protected Mappings mapAddress(String user, Domain domain) throws RecipientRewriteTableException {
        return (Mappings)this.getApplicableMappingRow(user, domain).map(MappingsImpl::fromRawString).orElse(MappingsImpl.empty());
    }

    private Optional<String> getApplicableMappingRow(String user, Domain domain) throws RecipientRewriteTableException {
        HTableInterface table = null;
        try {
            HTableInterface tableCopy = table = TablePool.getInstance().getRecipientRewriteTable();
            Optional optional = OptionalUtils.orSuppliers((Supplier[])new Supplier[]{Throwing.supplier(() -> Optional.ofNullable(this.getMapping(tableCopy, MappingSource.fromUser((String)user, (Domain)domain)))).sneakyThrow(), Throwing.supplier(() -> Optional.ofNullable(this.getMapping(tableCopy, MappingSource.fromDomain((Domain)domain)))).sneakyThrow(), Throwing.supplier(() -> Optional.ofNullable(this.getMapping(tableCopy, MappingSource.fromUser((String)user, (Domain)RecipientRewriteTable.Domains.WILDCARD)))).sneakyThrow()});
            return optional;
        }
        catch (IOException e) {
            log.error("Error while mapping address in HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while mapping address in HBase", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    private String getMapping(HTableInterface table, MappingSource source) throws IOException {
        Get get = new Get(Bytes.toBytes((String)this.getRowKey(source)));
        Result result = table.get(get);
        List keyValues = result.getColumn(HRecipientRewriteTable.COLUMN_FAMILY_NAME, HRecipientRewriteTable.COLUMN.MAPPING);
        if (keyValues.size() > 0) {
            return Bytes.toString((byte[])((KeyValue)keyValues.get(0)).getValue());
        }
        return null;
    }

    public void removeMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings map = this.getUserDomainMappings(source);
        if (map.size() > 1) {
            Mappings updatedMappings = map.remove(mapping);
            this.doUpdateMapping(source, updatedMappings.serialize());
        } else {
            this.doRemoveMapping(source);
        }
    }

    private void doUpdateMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        this.doAddMapping(source, mapping);
    }

    private void doRemoveMapping(MappingSource source) throws RecipientRewriteTableException {
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getRecipientRewriteTable();
            Delete delete = new Delete(Bytes.toBytes((String)this.getRowKey(source)));
            table.delete(delete);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while removing mapping from HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while removing mapping from HBase", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    private void doAddMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getRecipientRewriteTable();
            Put put = new Put(Bytes.toBytes((String)this.getRowKey(source)));
            put.add(HRecipientRewriteTable.COLUMN_FAMILY_NAME, HRecipientRewriteTable.COLUMN.MAPPING, Bytes.toBytes((String)mapping));
            table.put(put);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while adding mapping in HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while adding mapping in HBase", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)table);
        }
    }

    private String getRowKey(MappingSource source) {
        return source.getFixedUser() + ROW_SEPARATOR + source.getFixedDomain();
    }
}

