/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer.registrations;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.events.FlagsMessageEvent;
import org.apache.james.mailbox.indexer.events.ImpactingMessageEvent;
import org.apache.james.mailbox.indexer.events.MessageDeletedEvent;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UpdatedFlags;

public class MailboxRegistration
implements MailboxListener {
    private final Multimap<MessageUid, ImpactingMessageEvent> impactingMessageEvents = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    private final MailboxPath mailboxPath;

    public MailboxRegistration(MailboxPath mailboxPath) {
        this.mailboxPath = mailboxPath;
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.MAILBOX;
    }

    public List<ImpactingMessageEvent> getImpactingEvents(MessageUid uid) {
        return ImmutableList.copyOf((Collection)this.impactingMessageEvents.get((Object)uid));
    }

    public void event(Event event) {
        block3: {
            block2: {
                if (!(event instanceof MailboxListener.FlagsUpdated)) break block2;
                for (UpdatedFlags updatedFlags : ((MailboxListener.FlagsUpdated)event).getUpdatedFlags()) {
                    this.impactingMessageEvents.put((Object)updatedFlags.getUid(), (Object)new FlagsMessageEvent(this.mailboxPath, updatedFlags.getUid(), updatedFlags.getNewFlags()));
                }
                break block3;
            }
            if (!(event instanceof MailboxListener.Expunged)) break block3;
            for (MessageUid uid : ((MailboxListener.Expunged)event).getUids()) {
                this.impactingMessageEvents.put((Object)uid, (Object)new MessageDeletedEvent(this.mailboxPath, uid));
            }
        }
    }
}

