/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.events.FlagsMessageEvent;
import org.apache.james.mailbox.indexer.events.ImpactingEventType;
import org.apache.james.mailbox.indexer.events.ImpactingMessageEvent;
import org.apache.james.mailbox.indexer.registrations.GlobalRegistration;
import org.apache.james.mailbox.indexer.registrations.MailboxRegistration;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReIndexerImpl
implements ReIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReIndexerImpl.class);
    public static final int NO_LIMIT = 0;
    private final MailboxManager mailboxManager;
    private final ListeningMessageSearchIndex messageSearchIndex;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;

    @Inject
    public ReIndexerImpl(MailboxManager mailboxManager, ListeningMessageSearchIndex messageSearchIndex, MailboxSessionMapperFactory mailboxSessionMapperFactory) {
        this.mailboxManager = mailboxManager;
        this.messageSearchIndex = messageSearchIndex;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
    }

    @Override
    public void reIndex(MailboxPath path) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(path.getUser());
        this.reIndex(path, mailboxSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reIndex() throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession("re-indexing");
        LOGGER.info("Starting a full reindex");
        List mailboxPaths = this.mailboxManager.list(mailboxSession);
        GlobalRegistration globalRegistration = new GlobalRegistration();
        this.mailboxManager.addGlobalListener((MailboxListener)globalRegistration, mailboxSession);
        try {
            this.handleFullReindexingIterations(mailboxPaths, globalRegistration);
        }
        finally {
            this.mailboxManager.removeGlobalListener((MailboxListener)globalRegistration, mailboxSession);
        }
        LOGGER.info("Full reindex finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reIndex(MailboxPath path, MailboxSession mailboxSession) throws MailboxException {
        MailboxRegistration mailboxRegistration = new MailboxRegistration(path);
        LOGGER.info("Intend to reindex {}", (Object)path);
        Mailbox mailbox = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxByPath(path);
        this.messageSearchIndex.deleteAll(mailboxSession, mailbox);
        this.mailboxManager.addListener(path, (MailboxListener)mailboxRegistration, mailboxSession);
        try {
            this.handleMailboxIndexingIterations(mailboxSession, mailboxRegistration, mailbox, this.mailboxSessionMapperFactory.getMessageMapper(mailboxSession).findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, 0));
            LOGGER.info("Finish to reindex {}", (Object)path);
        }
        finally {
            this.mailboxManager.removeListener(path, (MailboxListener)mailboxRegistration, mailboxSession);
        }
    }

    private void handleFullReindexingIterations(List<MailboxPath> mailboxPaths, GlobalRegistration globalRegistration) throws MailboxException {
        for (MailboxPath mailboxPath : mailboxPaths) {
            Optional<MailboxPath> pathToIndex = globalRegistration.getPathToIndex(mailboxPath);
            if (!pathToIndex.isPresent()) continue;
            try {
                this.reIndex(pathToIndex.get());
            }
            catch (Throwable e) {
                LOGGER.error("Error while proceeding to full reindexing on {}", (Object)pathToIndex.get(), (Object)e);
            }
        }
    }

    private void handleMailboxIndexingIterations(MailboxSession mailboxSession, MailboxRegistration mailboxRegistration, Mailbox mailbox, Iterator<MailboxMessage> iterator) throws MailboxException {
        while (iterator.hasNext()) {
            MailboxMessage message = iterator.next();
            ImpactingMessageEvent impactingMessageEvent = this.findMostRelevant(mailboxRegistration.getImpactingEvents(message.getUid()));
            if (impactingMessageEvent == null) {
                this.messageSearchIndex.add(mailboxSession, mailbox, message);
                continue;
            }
            if (!(impactingMessageEvent instanceof FlagsMessageEvent)) continue;
            message.setFlags(((FlagsMessageEvent)impactingMessageEvent).getFlags());
            this.messageSearchIndex.add(mailboxSession, mailbox, message);
        }
    }

    private ImpactingMessageEvent findMostRelevant(Collection<ImpactingMessageEvent> messageEvents) {
        for (ImpactingMessageEvent impactingMessageEvent : messageEvents) {
            if (!impactingMessageEvent.getType().equals((Object)ImpactingEventType.Deletion)) continue;
            return impactingMessageEvent;
        }
        return (ImpactingMessageEvent)Iterables.getLast(messageEvents, null);
    }
}

