/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factorypostprocessor;

import com.google.common.base.Strings;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class EventsConfigurationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurationProvider confProvider = (ConfigurationProvider)beanFactory.getBean(ConfigurationProvider.class);
        try {
            HierarchicalConfiguration config = confProvider.getConfiguration("events");
            String type = config.getString("type", "default");
            String serialization = config.getString("serialization", "json");
            String publisher = config.getString("publisher", "kafka");
            String registration = config.getString("registration", "cassandra");
            String delivery = config.getString("delivery", "synchronous");
            String delegatingListenerAlias = this.getDelegatingListenerAlias(type);
            String serializationAlias = this.getSerializationAlias(serialization);
            String registrationAlias = this.getRegistrationAlias(registration);
            String deliveryAlias = this.getDeliveryString(delivery);
            String publisherAlias = null;
            String consumerAlias = null;
            if (publisher.equals("kafka")) {
                publisherAlias = "kafka-publisher";
                consumerAlias = "kafka-consumer";
            }
            this.detectInvalidValue(delegatingListenerAlias, "Delegating listener type " + type + " not supported!");
            this.detectInvalidValue(deliveryAlias, "Event delivery " + delivery + " not supported");
            beanFactory.registerAlias(delegatingListenerAlias, "delegating-listener");
            beanFactory.registerAlias(deliveryAlias, "event-delivery");
            if (!delegatingListenerAlias.equals("default")) {
                this.detectInvalidValue(serializationAlias, "Serialization system type " + serialization + " not supported!");
                this.detectInvalidValue(publisherAlias, "Publisher system type " + publisher + " not supported!");
                beanFactory.registerAlias(serializationAlias, "event-serializer");
                beanFactory.registerAlias(publisherAlias, "publisher");
                beanFactory.registerAlias(consumerAlias, "consumer");
                if (delegatingListenerAlias.equals("registered")) {
                    this.detectInvalidValue(registrationAlias, "Registration system type " + registration + " not supported!");
                    beanFactory.registerAlias(registrationAlias, "distant-mailbox-path-register-mapper");
                }
            }
        }
        catch (ConfigurationException e) {
            throw new FatalBeanException("Unable to config the mailboxmanager", (Throwable)e);
        }
    }

    private void detectInvalidValue(String registrationAlias, String message) throws ConfigurationException {
        if (Strings.isNullOrEmpty((String)registrationAlias)) {
            throw new ConfigurationException(message);
        }
    }

    private String getRegistrationAlias(String registration) {
        if (registration.equals("cassandra")) {
            return "cassandra-mailbox-path-register-mapper";
        }
        return null;
    }

    private String getSerializationAlias(String serialization) {
        if (serialization.equals("json")) {
            return "json-event-serializer";
        }
        if (serialization.equals("message-pack")) {
            return "message-pack-event-serializer";
        }
        return null;
    }

    private String getDelegatingListenerAlias(String type) {
        if (type.equals("default")) {
            return "default-delegating-listener";
        }
        if (type.equals("broadcast")) {
            return "broadcast-delegating-listener";
        }
        if (type.equals("registered")) {
            return "registered-delegating-listener";
        }
        return null;
    }

    public String getDeliveryString(String delivery) {
        if (delivery.equals("synchronous")) {
            return "synchronous-event-delivery";
        }
        if (delivery.equals("asynchronous")) {
            return "asynchronous-event-delivery";
        }
        if (delivery.equals("mixed")) {
            return "mixed-event-delivery";
        }
        return null;
    }
}

