/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import java.util.Set;
import javax.mail.internet.AddressException;
import org.apache.mailet.MailAddress;

public class MailAddressCollectionReader {
    public static Set<MailAddress> read(String condition) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)condition) ? 1 : 0) != 0);
        return FluentIterable.from((Iterable)Splitter.onPattern((String)"(,| |\t)").split((CharSequence)condition)).filter((Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return !Strings.isNullOrEmpty((String)s);
            }
        }).transform((Function)new Function<String, MailAddress>(){

            public MailAddress apply(String s) {
                try {
                    return new MailAddress(s);
                }
                catch (AddressException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }).toSet();
    }
}

