/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Strings;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericRecipientMatcher;

public class RecipientIsRegex
extends GenericRecipientMatcher {
    Pattern pattern = null;

    public void init() throws MessagingException {
        String patternString = this.getCondition();
        if (Strings.isNullOrEmpty((String)patternString)) {
            throw new MessagingException("Pattern is missing");
        }
        patternString = patternString.trim();
        try {
            this.pattern = Pattern.compile(patternString);
        }
        catch (PatternSyntaxException mpe) {
            throw new MessagingException("Malformed pattern: " + patternString, (Exception)mpe);
        }
    }

    public boolean matchRecipient(MailAddress recipient) {
        String myRecipient = recipient.toString();
        return this.pattern.matcher(myRecipient).matches();
    }
}

