/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Strings;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.transport.matchers.utils.MailAddressCollectionReader;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericRecipientMatcher;

public class RecipientIs
extends GenericRecipientMatcher {
    private Collection<MailAddress> recipients;

    public void init() throws MessagingException {
        if (Strings.isNullOrEmpty((String)this.getCondition())) {
            throw new MessagingException("RecipientIs should have a condition  composed of a list of mail addresses");
        }
        this.recipients = MailAddressCollectionReader.read(this.getCondition());
        if (this.recipients.isEmpty()) {
            throw new MessagingException("RecipientIs should have at least one address passed as a condition");
        }
    }

    public boolean matchRecipient(MailAddress recipient) {
        return this.recipients.contains(recipient);
    }
}

