/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.io.Serializable;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

public class HasMailAttributeWithValue
extends GenericMatcher {
    private String fieldAttributeName;
    private String fieldAttributeValue;

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Serializable attributeValue = mail.getAttribute(this.getAttributeName());
        if (attributeValue != null && attributeValue.toString().trim().equals(this.getAttributeValue())) {
            return mail.getRecipients();
        }
        return null;
    }

    protected String getAttributeName() {
        return this.fieldAttributeName;
    }

    protected String getAttributeValue() {
        return this.fieldAttributeValue;
    }

    protected void setAttributeName(String attributeName) {
        this.fieldAttributeName = attributeName;
    }

    protected void setAttributeValue(String attributeValue) {
        this.fieldAttributeValue = attributeValue;
    }

    public void init() throws MessagingException {
        String condition = this.getCondition().trim();
        int commaPosition = condition.indexOf(44);
        if (-1 == commaPosition) {
            throw new MessagingException("Syntax Error. Missing ','.");
        }
        if (0 == commaPosition) {
            throw new MessagingException("Syntax Error. Missing attribute name.");
        }
        this.setAttributeName(condition.substring(0, commaPosition).trim());
        this.setAttributeValue(condition.substring(commaPosition + 1).trim());
    }

    public String getMatcherInfo() {
        return "Has Mail Attribute With Value Matcher";
    }
}

