/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;

public class MimeMessageUtils {
    private final MimeMessage message;

    public MimeMessageUtils(MimeMessage message) {
        this.message = message;
    }

    public Optional<String> subjectWithPrefix(String subjectPrefix) throws MessagingException {
        return this.prefixSubject(this.message.getSubject(), subjectPrefix);
    }

    private Optional<String> prefixSubject(String subject, String subjectPrefix) throws MessagingException {
        if (!Strings.isNullOrEmpty((String)subject)) {
            return Optional.of((Object)Joiner.on((char)' ').join((Object)subjectPrefix, (Object)subject, new Object[0]));
        }
        return Optional.of((Object)subjectPrefix);
    }

    public Optional<String> subjectWithPrefix(String subjectPrefix, Mail originalMail, String subject) throws MessagingException {
        return this.buildNewSubject(subjectPrefix, originalMail.getMessage().getSubject(), subject);
    }

    @VisibleForTesting
    Optional<String> buildNewSubject(String subjectPrefix, String originalSubject, String subject) throws MessagingException {
        String nullablePrefix = Strings.emptyToNull((String)subjectPrefix);
        if (nullablePrefix == null && subject == null) {
            return Optional.absent();
        }
        if (nullablePrefix == null) {
            return Optional.of((Object)subject);
        }
        String chosenSubject = this.chooseSubject(subject, originalSubject);
        return this.prefixSubject(chosenSubject, nullablePrefix);
    }

    private String chooseSubject(String newSubject, String originalSubject) {
        return (String)Optional.fromNullable((Object)newSubject).or((Object)originalSubject);
    }

    public String getMessageHeaders() throws MessagingException {
        Enumeration heads = this.message.getAllHeaderLines();
        StringBuilder headBuffer = new StringBuilder(1024);
        while (heads.hasMoreElements()) {
            headBuffer.append((String)heads.nextElement()).append("\r\n");
        }
        return headBuffer.toString();
    }
}

