/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Optional;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class ToProcessor
extends GenericMailet {
    private boolean debug;
    private String processor;
    private Optional<String> noticeText;

    public void init() throws MailetException {
        this.debug = this.isDebug();
        this.processor = this.getInitParameter("processor");
        if (this.processor == null) {
            throw new MailetException("processor parameter is required");
        }
        this.noticeText = Optional.fromNullable((Object)this.getInitParameter("notice"));
    }

    private boolean isDebug() {
        return this.getInitParameter("debug", false);
    }

    public String getMailetInfo() {
        return "ToProcessor Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        if (this.debug) {
            this.log(String.format("Sending mail %s to %s", mail, this.processor));
        }
        mail.setState(this.processor);
        if (this.noticeText.isPresent()) {
            this.setNoticeInErrorMessage(mail);
        }
    }

    private void setNoticeInErrorMessage(Mail mail) {
        if (mail.getErrorMessage() == null) {
            mail.setErrorMessage((String)this.noticeText.get());
        } else {
            mail.setErrorMessage(String.format("%s\r\n%s", mail.getErrorMessage(), this.noticeText.get()));
        }
    }
}

