/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class MailAttributesToMimeHeaders
extends GenericMailet {
    private static final String CONFIGURATION_ERROR_MESSAGE = "Invalid config. Please use \"attributeName; headerName\"";
    private Map<String, String> mappings;

    public void init() throws MessagingException {
        String simplemappings = this.getInitParameter("simplemapping");
        ImmutableMap.Builder mappingsBuilder = ImmutableMap.builder();
        if (simplemappings != null) {
            for (String mapping : Splitter.on((char)',').split((CharSequence)simplemappings)) {
                List pair = Splitter.on((char)';').trimResults().splitToList((CharSequence)mapping);
                if (pair.size() != 2) {
                    throw new MessagingException(CONFIGURATION_ERROR_MESSAGE);
                }
                mappingsBuilder.put(pair.get(0), pair.get(1));
            }
        } else {
            throw new MessagingException(CONFIGURATION_ERROR_MESSAGE);
        }
        this.mappings = mappingsBuilder.build();
    }

    public void service(Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
                String value = (String)((Object)mail.getAttribute(entry.getKey()));
                if (value == null) continue;
                String headerName = entry.getValue();
                message.addHeader(headerName, value);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            this.log(e.getMessage());
        }
    }
}

