/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class ClamAVScan
extends GenericMailet {
    private static final int DEFAULT_PORT = 3310;
    private static final int DEFAULT_MAX_PINGS = 6;
    private static final int DEFAULT_PING_INTERVAL_MILLI = 30000;
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final String STREAM_PORT_STRING = "PORT ";
    private static final String FOUND_STRING = "FOUND";
    private static final String MAIL_ATTRIBUTE_NAME = "org.apache.james.infected";
    private static final String HEADER_NAME = "X-MessageIsInfected";
    private boolean debug;
    private String host;
    private int port;
    private int maxPings;
    private int pingIntervalMilli;
    private int streamBufferSize;
    private InetAddress[] addresses;
    private int nextAddressIndex;

    public String getMailetInfo() {
        return "Antivirus Check using ClamAV (CLAMD)";
    }

    protected String[] getAllowedInitParameters() {
        return new String[]{"debug", "host", "port", "maxPings", "pingIntervalMilli", "streamBufferSize"};
    }

    protected void initDebug() {
        String debugParam = this.getInitParameter("debug");
        this.setDebug(debugParam == null ? false : Boolean.valueOf(debugParam));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected void initHost() throws UnknownHostException {
        this.setHost(this.getInitParameter("host"));
        if (this.isDebug()) {
            this.log("host: " + this.getHost());
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) throws UnknownHostException {
        this.host = host;
        this.setAddresses(InetAddress.getAllByName(host));
        this.nextAddressIndex = 0;
    }

    protected void initPort() {
        String portParam = this.getInitParameter("port");
        this.setPort(portParam == null ? 3310 : Integer.parseInt(portParam));
        if (this.isDebug()) {
            this.log("port: " + this.getPort());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void initMaxPings() {
        String maxPingsParam = this.getInitParameter("maxPings");
        this.setMaxPings(maxPingsParam == null ? 6 : Integer.parseInt(maxPingsParam));
        if (this.isDebug()) {
            this.log("maxPings: " + this.getMaxPings());
        }
    }

    public int getMaxPings() {
        return this.maxPings;
    }

    public void setMaxPings(int maxPings) {
        this.maxPings = maxPings;
    }

    protected void initPingIntervalMilli() {
        String pingIntervalMilliParam = this.getInitParameter("pingIntervalMilli");
        this.setPingIntervalMilli(pingIntervalMilliParam == null ? 30000 : Integer.parseInt(pingIntervalMilliParam));
        if (this.isDebug()) {
            this.log("pingIntervalMilli: " + this.getPingIntervalMilli());
        }
    }

    public int getPingIntervalMilli() {
        return this.pingIntervalMilli;
    }

    public void setPingIntervalMilli(int pingIntervalMilli) {
        this.pingIntervalMilli = pingIntervalMilli;
    }

    protected void initStreamBufferSize() {
        String streamBufferSizeParam = this.getInitParameter("streamBufferSize");
        this.setStreamBufferSize(streamBufferSizeParam == null ? 8192 : Integer.parseInt(streamBufferSizeParam));
        if (this.isDebug()) {
            this.log("streamBufferSize: " + this.getStreamBufferSize());
        }
    }

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public void setStreamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
    }

    protected InetAddress getAddresses(int index) {
        return this.addresses[index];
    }

    protected InetAddress[] getAddresses() {
        return this.addresses;
    }

    protected void setAddresses(InetAddress[] addresses) {
        this.addresses = addresses;
    }

    protected synchronized InetAddress getNextAddress() {
        InetAddress address = this.getAddresses(this.nextAddressIndex);
        ++this.nextAddressIndex;
        if (this.nextAddressIndex >= this.getAddressesCount()) {
            this.nextAddressIndex = 0;
        }
        return address;
    }

    public int getAddressesCount() {
        return this.getAddresses().length;
    }

    protected Socket getClamdSocket() throws MessagingException {
        HashSet<InetAddress> usedAddresses = new HashSet<InetAddress>(this.getAddressesCount());
        while (true) {
            if (usedAddresses.size() >= this.getAddressesCount()) {
                String logText = "Unable to connect to CLAMD. All addresses failed.";
                this.log(logText + " Giving up.");
                throw new MessagingException(logText);
            }
            InetAddress address = this.getNextAddress();
            if (!usedAddresses.add(address)) continue;
            try {
                return new Socket(address, this.getPort());
            }
            catch (IOException ioe) {
                this.log("Exception caught acquiring main socket to CLAMD on " + address + " on port " + this.getPort() + ": " + ioe.getMessage());
                this.getNextAddress();
                continue;
            }
            break;
        }
    }

    public void init() throws MessagingException {
        this.checkInitParameters(this.getAllowedInitParameters());
        try {
            this.initDebug();
            if (this.isDebug()) {
                this.log("Initializing");
            }
            this.initHost();
            this.initPort();
            this.initMaxPings();
            this.initPingIntervalMilli();
            this.initStreamBufferSize();
            if (this.getMaxPings() > 0) {
                this.ping();
            }
        }
        catch (Exception e) {
            this.log("Exception thrown", e);
            throw new MessagingException("Exception thrown", e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        if (mail.getAttribute(MAIL_ATTRIBUTE_NAME) != null) {
            return;
        }
        MimeMessage mimeMessage = mail.getMessage();
        if (mimeMessage == null) {
            this.log("Null MimeMessage. Will send to ghost");
            this.logMailInfo(mail);
            mail.setState("ghost");
            return;
        }
        Socket socket = this.getClamdSocket();
        BufferedReader reader = null;
        PrintWriter writer = null;
        Socket streamSocket = null;
        BufferedOutputStream bos = null;
        try {
            String answer;
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ASCII"));
            writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            writer.println("STREAM");
            writer.flush();
            int streamPort = this.getStreamPortFromAnswer(reader.readLine());
            streamSocket = new Socket(socket.getInetAddress(), streamPort);
            bos = new BufferedOutputStream(streamSocket.getOutputStream(), this.getStreamBufferSize());
            mimeMessage.writeTo((OutputStream)bos);
            bos.flush();
            bos.close();
            streamSocket.close();
            boolean virusFound = false;
            String logMessage = "";
            while ((answer = reader.readLine()) != null) {
                if (!(answer = answer.trim()).substring(answer.length() - FOUND_STRING.length()).equals(FOUND_STRING)) continue;
                virusFound = true;
                logMessage = answer + " (by CLAMD on " + socket.getInetAddress() + ")";
                this.log(logMessage);
            }
            reader.close();
            writer.close();
            if (virusFound) {
                String errorMessage = mail.getErrorMessage();
                errorMessage = errorMessage == null ? "" : errorMessage + "\r\n";
                StringBuilder sb = new StringBuilder(errorMessage);
                sb.append(logMessage).append("\r\n");
                this.logMailInfo(mail);
                this.logMessageInfo(mimeMessage);
                mail.setAttribute(MAIL_ATTRIBUTE_NAME, (Serializable)((Object)"true"));
                mail.setErrorMessage(sb.toString());
                mimeMessage.setHeader(HEADER_NAME, "true");
            } else {
                if (this.isDebug()) {
                    this.log("OK (by CLAMD on " + socket.getInetAddress() + ")");
                }
                mail.setAttribute(MAIL_ATTRIBUTE_NAME, (Serializable)((Object)"false"));
                mimeMessage.setHeader(HEADER_NAME, "false");
            }
            try {
                this.saveChanges(mimeMessage);
            }
            catch (Exception ex) {
                this.log("Exception caught while saving changes (header) to the MimeMessage. Ignoring ...", ex);
            }
            this.shutdownReader(reader);
            this.shutdownWriter(writer);
        }
        catch (Exception ex) {
            try {
                this.log("Exception caught calling CLAMD on " + socket.getInetAddress() + ": " + ex.getMessage(), ex);
                throw new MessagingException("Exception caught", ex);
            }
            catch (Throwable throwable) {
                this.shutdownReader(reader);
                this.shutdownWriter(writer);
                ClamAVScan.shutdownStream(bos);
                ClamAVScan.shutdownSocket(streamSocket);
                ClamAVScan.shutdownSocket(socket);
                throw throwable;
            }
        }
        ClamAVScan.shutdownStream(bos);
        ClamAVScan.shutdownSocket(streamSocket);
        ClamAVScan.shutdownSocket(socket);
    }

    private static void shutdownStream(OutputStream output) {
        if (null == output) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void shutdownSocket(Socket socket) {
        if (null == socket) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void shutdownWriter(Writer output) {
        if (null == output) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void shutdownReader(Reader input) {
        if (null == input) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void ping() throws Exception {
        for (int i = 0; i < this.getAddressesCount(); ++i) {
            this.ping(this.getAddresses(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ping(InetAddress address) throws Exception {
        Socket socket = null;
        int ping = 1;
        while (true) {
            if (this.isDebug()) {
                this.log("Trial #" + ping + "/" + this.getMaxPings() + " - creating socket connected to " + address + " on port " + this.getPort());
            }
            try {
                socket = new Socket(address, this.getPort());
            }
            catch (ConnectException ce) {
                this.log("Trial #" + ping + "/" + this.getMaxPings() + " - exception caught: " + ce.toString() + " while creating socket connected to " + address + " on port " + this.getPort());
                if (++ping > this.getMaxPings()) break;
                this.log("Waiting " + this.getPingIntervalMilli() + " milliseconds before retrying ...");
                Thread.sleep(this.getPingIntervalMilli());
                continue;
            }
            break;
        }
        if (socket == null) {
            throw new ConnectException("maxPings exceeded: " + this.getMaxPings() + ". Giving up. The clamd daemon seems not to be running");
        }
        try {
            String answer;
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ASCII"));
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            this.log("Sending: \"PING\" to " + address + " ...");
            writer.println("PING");
            writer.flush();
            boolean pongReceived = false;
            while ((answer = reader.readLine()) != null) {
                answer = answer.trim();
                this.log("Received: \"" + answer + "\"");
                if (!(answer = answer.trim()).equals("PONG")) continue;
                pongReceived = true;
            }
            reader.close();
            writer.close();
            if (!pongReceived) {
                throw new ConnectException("Bad answer from \"PING\" probe: expecting \"PONG\"");
            }
        }
        finally {
            socket.close();
        }
    }

    protected final int getStreamPortFromAnswer(String answer) throws ConnectException {
        int port = -1;
        if (answer != null && answer.startsWith(STREAM_PORT_STRING)) {
            try {
                port = Integer.parseInt(answer.substring(STREAM_PORT_STRING.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port <= 0) {
            throw new ConnectException("\"PORT nn\" expected - unable to parse: \"" + answer + "\"");
        }
        return port;
    }

    protected final void saveChanges(MimeMessage message) throws MessagingException {
        String messageId = message.getMessageID();
        message.saveChanges();
        if (messageId != null) {
            message.setHeader("Message-ID", messageId);
        }
    }

    private void logMailInfo(Mail mail) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        out.print("Mail details:");
        out.print(" MAIL FROM: " + mail.getSender());
        Iterator rcptTo = mail.getRecipients().iterator();
        out.print(", RCPT TO: " + rcptTo.next());
        while (rcptTo.hasNext()) {
            out.print(", " + rcptTo.next());
        }
        this.log(sout.toString());
    }

    private void logMessageInfo(MimeMessage mimeMessage) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        out.println("MimeMessage details:");
        try {
            String[] rcpts;
            String[] sender;
            if (mimeMessage.getSubject() != null) {
                out.println("  Subject: " + mimeMessage.getSubject());
            }
            if (mimeMessage.getSentDate() != null) {
                out.println("  Sent date: " + mimeMessage.getSentDate());
            }
            if ((sender = mimeMessage.getHeader("From")) != null) {
                out.print("  From: ");
                for (String aSender : sender) {
                    out.print(aSender + " ");
                }
                out.println();
            }
            if ((rcpts = mimeMessage.getHeader("To")) != null) {
                out.print("  To: ");
                for (String rcpt : rcpts) {
                    out.print(rcpt + " ");
                }
                out.println();
            }
            if ((rcpts = mimeMessage.getHeader("Cc")) != null) {
                out.print("  CC: ");
                for (String rcpt : rcpts) {
                    out.print(rcpt + " ");
                }
                out.println();
            }
            out.print("  Size (in bytes): " + mimeMessage.getSize());
            if (mimeMessage.getLineCount() >= 0) {
                out.print(", Number of lines: " + mimeMessage.getLineCount());
            }
        }
        catch (MessagingException me) {
            this.log("Exception caught reporting message details", me);
        }
        this.log(sout.toString());
    }
}

