/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class AddFooter
extends GenericMailet {
    private static final String HTML_BR_TAG = "<br />";
    private static final String CARRIAGE_RETURN = "\r\n";
    private static final Pattern BODY_CLOSING_TAG = Pattern.compile("((?i:</body>))");
    private String plainTextFooter;

    public void init() throws MessagingException {
        this.plainTextFooter = this.getInitParameter("text");
    }

    public String getMailetInfo() {
        return "AddFooter Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        try {
            MimeMessage message = mail.getMessage();
            if (this.attachFooter((MimePart)message)) {
                message.saveChanges();
            } else {
                this.log("Unable to add footer to mail " + mail.getName());
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log("UnsupportedEncoding Unable to add footer to mail " + mail.getName());
        }
        catch (IOException ioe) {
            throw new MessagingException("Could not read message", (Exception)ioe);
        }
    }

    private boolean attachFooter(MimePart part) throws MessagingException, IOException {
        MimeMultipart multipart;
        Optional<String> content;
        String contentType = part.getContentType();
        if (part.getContent() instanceof String && (content = this.attachFooterToTextPart(part)).isPresent()) {
            part.setContent(content.get(), contentType);
            part.setHeader("Content-Type", contentType);
            return true;
        }
        if (part.isMimeType("multipart/mixed") || part.isMimeType("multipart/related")) {
            multipart = (MimeMultipart)part.getContent();
            return this.attachFooterToFirstPart(multipart);
        }
        if (part.isMimeType("multipart/alternative")) {
            multipart = (MimeMultipart)part.getContent();
            return this.attachFooterToAllSubparts(multipart);
        }
        return false;
    }

    private String attachFooterToText(String content) throws MessagingException, IOException {
        StringBuilder builder = new StringBuilder(content);
        this.ensureTrailingCarriageReturn(content, builder);
        builder.append(this.getFooterText());
        return builder.toString();
    }

    private void ensureTrailingCarriageReturn(String content, StringBuilder builder) {
        if (!content.endsWith("\n")) {
            builder.append(CARRIAGE_RETURN);
        }
    }

    private String attachFooterToHTML(String content) throws MessagingException, IOException {
        Matcher matcher = BODY_CLOSING_TAG.matcher(content);
        if (!matcher.find()) {
            return content + this.getFooterHTML();
        }
        int insertionIndex = matcher.start(matcher.groupCount() - 1);
        return content.substring(0, insertionIndex) + this.getFooterHTML() + content.substring(insertionIndex, content.length());
    }

    private Optional<String> attachFooterToTextPart(MimePart part) throws MessagingException, IOException {
        String content = (String)part.getContent();
        if (part.isMimeType("text/plain")) {
            return Optional.of((Object)this.attachFooterToText(content));
        }
        if (part.isMimeType("text/html")) {
            return Optional.of((Object)this.attachFooterToHTML(content));
        }
        return Optional.absent();
    }

    private boolean attachFooterToFirstPart(MimeMultipart multipart) throws MessagingException, IOException {
        MimeBodyPart firstPart = (MimeBodyPart)multipart.getBodyPart(0);
        return this.attachFooter((MimePart)firstPart);
    }

    private boolean attachFooterToAllSubparts(MimeMultipart multipart) throws MessagingException, IOException {
        int count = multipart.getCount();
        boolean isFooterAttached = false;
        for (int index = 0; index < count; ++index) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)multipart.getBodyPart(index);
            isFooterAttached |= this.attachFooter((MimePart)mimeBodyPart);
        }
        return isFooterAttached;
    }

    private String getFooterText() {
        return this.plainTextFooter;
    }

    private String getFooterHTML() {
        String text = this.getFooterText();
        return HTML_BR_TAG + text.replaceAll(CARRIAGE_RETURN, HTML_BR_TAG);
    }
}

