/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es.search;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;

public class ScrollIterable
implements Iterable<SearchResponse> {
    private static final TimeValue TIMEOUT = new TimeValue(60000L);
    private final Client client;
    private final SearchRequestBuilder searchRequestBuilder;

    public ScrollIterable(Client client, SearchRequestBuilder searchRequestBuilder) {
        this.client = client;
        this.searchRequestBuilder = searchRequestBuilder;
    }

    @Override
    public Iterator<SearchResponse> iterator() {
        return new ScrollIterator(this.client, this.searchRequestBuilder);
    }

    public Stream<SearchResponse> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static class ScrollIterator
    implements Iterator<SearchResponse> {
        private final Client client;
        private ListenableActionFuture<SearchResponse> searchResponseFuture;

        public ScrollIterator(Client client, SearchRequestBuilder searchRequestBuilder) {
            this.client = client;
            this.searchResponseFuture = searchRequestBuilder.execute();
        }

        @Override
        public boolean hasNext() {
            return !this.allSearchResponsesConsumed((SearchResponse)this.searchResponseFuture.actionGet());
        }

        @Override
        public SearchResponse next() {
            SearchResponse result = (SearchResponse)this.searchResponseFuture.actionGet();
            this.searchResponseFuture = this.client.prepareSearchScroll(result.getScrollId()).setScroll(TIMEOUT).execute();
            return result;
        }

        private boolean allSearchResponsesConsumed(SearchResponse searchResponse) {
            return searchResponse.getHits().getHits().length == 0;
        }
    }
}

