/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import java.io.IOException;
import org.apache.james.backends.es.IndexName;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCreationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexCreationFactory.class);
    private static final int DEFAULT_NB_SHARDS = 1;
    private static final int DEFAULT_NB_REPLICA = 0;
    public static final String CASE_INSENSITIVE = "case_insensitive";

    public static Client createIndex(Client client, IndexName name, int nbShards, int nbReplica) {
        try {
            return IndexCreationFactory.createIndex(client, name, IndexCreationFactory.generateSetting(nbShards, nbReplica));
        }
        catch (IOException e) {
            LOGGER.error("Error while creating index : ", (Throwable)e);
            return client;
        }
    }

    public static Client createIndex(Client client, IndexName name) {
        return IndexCreationFactory.createIndex(client, name, 1, 0);
    }

    private static Client createIndex(Client client, IndexName name, XContentBuilder settings) {
        try {
            client.admin().indices().prepareCreate(name.getValue()).setSettings(settings).execute().actionGet();
        }
        catch (IndexAlreadyExistsException exception) {
            LOGGER.info("Index [" + name + "] already exist");
        }
        return client;
    }

    private static XContentBuilder generateSetting(int nbShards, int nbReplica) throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("number_of_shards", nbShards).field("number_of_replicas", nbReplica).startObject("analysis").startObject("analyzer").startObject(CASE_INSENSITIVE).field("tokenizer", "keyword").startArray("filter").value("lowercase").endArray().endObject().endObject().endObject().endObject();
    }
}

