/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.es.DeleteByQueryPerformer;
import org.apache.james.backends.es.IndexName;
import org.apache.james.backends.es.TypeName;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchIndexer.class);
    private final Client client;
    private final DeleteByQueryPerformer deleteByQueryPerformer;
    private final IndexName indexName;
    private final TypeName typeName;

    @Inject
    public ElasticSearchIndexer(Client client, DeleteByQueryPerformer deleteByQueryPerformer, IndexName indexName, TypeName typeName) {
        this.client = client;
        this.deleteByQueryPerformer = deleteByQueryPerformer;
        this.indexName = indexName;
        this.typeName = typeName;
    }

    public IndexResponse indexMessage(String id, String content) {
        this.checkArgument(content);
        LOGGER.debug(String.format("Indexing %s: %s", id, content));
        return (IndexResponse)this.client.prepareIndex(this.indexName.getValue(), this.typeName.getValue(), id).setSource(content).get();
    }

    public Optional<BulkResponse> updateMessages(List<UpdatedRepresentation> updatedDocumentParts) {
        try {
            Preconditions.checkNotNull(updatedDocumentParts);
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            updatedDocumentParts.forEach(updatedDocumentPart -> bulkRequestBuilder.add(this.client.prepareUpdate(this.indexName.getValue(), this.typeName.getValue(), updatedDocumentPart.getId()).setDoc(updatedDocumentPart.getUpdatedDocumentPart())));
            return Optional.of(bulkRequestBuilder.get());
        }
        catch (ValidationException e) {
            LOGGER.warn("Error while updating index", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<BulkResponse> deleteMessages(List<String> ids) {
        try {
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            ids.forEach(id -> bulkRequestBuilder.add(this.client.prepareDelete(this.indexName.getValue(), this.typeName.getValue(), id)));
            return Optional.of(bulkRequestBuilder.get());
        }
        catch (ValidationException e) {
            LOGGER.warn("Error while deleting index", (Throwable)e);
            return Optional.empty();
        }
    }

    public void deleteAllMatchingQuery(QueryBuilder queryBuilder) {
        this.deleteByQueryPerformer.perform(queryBuilder);
    }

    private void checkArgument(String content) {
        Preconditions.checkArgument((content != null ? 1 : 0) != 0, (Object)"content should be provided");
    }

    public static class UpdatedRepresentation {
        private final String id;
        private final String updatedDocumentPart;

        public UpdatedRepresentation(String id, String updatedDocumentPart) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)("Updated id must be specified " + id));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)updatedDocumentPart) ? 1 : 0) != 0, (Object)"Updated document must be specified");
            this.id = id;
            this.updatedDocumentPart = updatedDocumentPart;
        }

        public String getId() {
            return this.id;
        }

        public String getUpdatedDocumentPart() {
            return this.updatedDocumentPart;
        }

        public final boolean equals(Object o) {
            if (o instanceof UpdatedRepresentation) {
                UpdatedRepresentation other = (UpdatedRepresentation)o;
                return Objects.equals(this.id, other.id) && Objects.equals(this.updatedDocumentPart, other.updatedDocumentPart);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.id, this.updatedDocumentPart);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("updatedDocumentPart", (Object)this.updatedDocumentPart).toString();
        }
    }
}

