/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.backends.es.IndexName;
import org.apache.james.backends.es.TypeName;
import org.apache.james.backends.es.search.ScrollIterable;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;

public class DeleteByQueryPerformer {
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final TimeValue TIMEOUT = new TimeValue(60000L);
    private final Client client;
    private final ExecutorService executor;
    private final int batchSize;
    private final IndexName indexName;
    private final TypeName typeName;

    @Inject
    public DeleteByQueryPerformer(Client client, @Named(value="AsyncExecutor") ExecutorService executor, IndexName indexName, TypeName typeName) {
        this(client, executor, 100, indexName, typeName);
    }

    @VisibleForTesting
    public DeleteByQueryPerformer(Client client, @Named(value="AsyncExecutor") ExecutorService executor, int batchSize, IndexName indexName, TypeName typeName) {
        this.client = client;
        this.executor = executor;
        this.batchSize = batchSize;
        this.indexName = indexName;
        this.typeName = typeName;
    }

    public void perform(QueryBuilder queryBuilder) {
        this.executor.execute(() -> this.doDeleteByQuery(queryBuilder));
    }

    protected void doDeleteByQuery(QueryBuilder queryBuilder) {
        new ScrollIterable(this.client, this.client.prepareSearch(new String[]{this.indexName.getValue()}).setTypes(new String[]{this.typeName.getValue()}).setScroll(TIMEOUT).setNoFields().setQuery(queryBuilder).setSize(this.batchSize)).stream().forEach(searchResponse -> this.deleteRetrievedIds(this.client, (SearchResponse)searchResponse));
    }

    private ListenableActionFuture<BulkResponse> deleteRetrievedIds(Client client, SearchResponse searchResponse) {
        BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
        for (SearchHit hit : searchResponse.getHits()) {
            bulkRequestBuilder.add(((DeleteRequestBuilder)client.prepareDelete().setIndex(this.indexName.getValue())).setType(this.typeName.getValue()).setId(hit.getId()));
        }
        return bulkRequestBuilder.execute();
    }
}

