/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ConsumerChainer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import org.apache.james.backends.es.ClientProvider;
import org.apache.james.util.Host;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ClientProviderImpl
implements ClientProvider {
    private final ImmutableList<Host> hosts;

    public static ClientProviderImpl forHost(String address, Integer port) {
        ClientProviderImpl.isValidPort(port);
        return new ClientProviderImpl((ImmutableList<Host>)ImmutableList.of((Object)Host.from((String)address, (int)port)));
    }

    public static ClientProviderImpl fromHostsString(String hostsString) {
        Preconditions.checkNotNull((Object)hostsString, (Object)"HostString should not be null");
        return new ClientProviderImpl((ImmutableList<Host>)Host.parseHosts((String)hostsString));
    }

    private static boolean isValidPort(Integer port) {
        return port > 0 && port <= 65535;
    }

    private ClientProviderImpl(ImmutableList<Host> hosts) {
        Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"You should provide at least one host");
        this.hosts = hosts;
    }

    @Override
    public Client get() {
        TransportClient transportClient = TransportClient.builder().build();
        ConsumerChainer consumer = Throwing.consumer(host -> transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host.getHostName()), host.getPort())));
        this.hosts.forEach(consumer.sneakyThrow());
        return transportClient;
    }
}

