/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.james.mailbox.tika.TikaConfiguration;
import org.apache.james.mailbox.tika.TikaException;
import org.apache.james.mailbox.tika.TikaHttpClient;

public class TikaHttpClientImpl
implements TikaHttpClient {
    private static final String RECURSIVE_METADATA_AS_TEXT_ENDPOINT = "/rmeta/text";
    private final TikaConfiguration tikaConfiguration;
    private final URI recursiveMetaData;

    public TikaHttpClientImpl(TikaConfiguration tikaConfiguration) throws URISyntaxException {
        this.tikaConfiguration = tikaConfiguration;
        this.recursiveMetaData = this.buildURI(tikaConfiguration).resolve(RECURSIVE_METADATA_AS_TEXT_ENDPOINT);
    }

    private URI buildURI(TikaConfiguration tikaConfiguration) throws URISyntaxException {
        return new URIBuilder().setHost(tikaConfiguration.getHost()).setPort(tikaConfiguration.getPort()).setScheme("http").build();
    }

    @Override
    public InputStream recursiveMetaDataAsJson(InputStream inputStream, String contentType) throws TikaException {
        try {
            return Request.Put((URI)this.recursiveMetaData).socketTimeout(this.tikaConfiguration.getTimeoutInMillis()).bodyStream(inputStream, ContentType.create((String)contentType)).execute().returnContent().asStream();
        }
        catch (IOException e) {
            throw new TikaException(e);
        }
    }
}

