/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import com.google.common.base.Preconditions;
import java.util.Optional;

public class TikaConfiguration {
    private final String host;
    private final int port;
    private final int timeoutInMillis;

    public static Builder builder() {
        return new Builder();
    }

    private TikaConfiguration(String host, int port, int timeoutInMillis) {
        this.host = host;
        this.port = port;
        this.timeoutInMillis = timeoutInMillis;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public static class Builder {
        private Optional<String> host = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<Integer> timeoutInMillis = Optional.empty();

        private Builder() {
        }

        public Builder host(String host) {
            this.host = Optional.ofNullable(host);
            return this;
        }

        public Builder port(int port) {
            this.port = Optional.of(port);
            return this;
        }

        public Builder timeoutInMillis(int timeoutInMillis) {
            this.timeoutInMillis = Optional.of(timeoutInMillis);
            return this;
        }

        public TikaConfiguration build() {
            Preconditions.checkState((boolean)this.host.isPresent(), (Object)"'host' is mandatory");
            Preconditions.checkState((boolean)this.port.isPresent(), (Object)"'port' is mandatory");
            Preconditions.checkState((boolean)this.timeoutInMillis.isPresent(), (Object)"'timeoutInMillis' is mandatory");
            return new TikaConfiguration(this.host.get(), this.port.get(), this.timeoutInMillis.get());
        }
    }
}

