/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry.naming.ldap;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.apache.james.util.retry.api.RetrySchedule;
import org.apache.james.util.retry.naming.LoggingRetryHandler;
import org.apache.james.util.retry.naming.directory.RetryingDirContext;
import org.slf4j.Logger;

public abstract class RetryingLdapContext
extends RetryingDirContext
implements LdapContext {
    public RetryingLdapContext(RetrySchedule schedule, int maxRetries, Logger logger) throws NamingException {
        super(schedule, maxRetries, logger);
    }

    @Override
    public ExtendedResponse extendedOperation(final ExtendedRequest request) throws NamingException {
        return (ExtendedResponse)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Object operation() throws NamingException {
                return ((LdapContext)RetryingLdapContext.this.getDelegate()).extendedOperation(request);
            }
        }.perform();
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return (Control[])new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Object operation() throws NamingException {
                return ((LdapContext)RetryingLdapContext.this.getDelegate()).getConnectControls();
            }
        }.perform();
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return (Control[])new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Object operation() throws NamingException {
                return ((LdapContext)RetryingLdapContext.this.getDelegate()).getRequestControls();
            }
        }.perform();
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return (Control[])new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Object operation() throws NamingException {
                return ((LdapContext)RetryingLdapContext.this.getDelegate()).getResponseControls();
            }
        }.perform();
    }

    @Override
    public LdapContext newInstance(final Control[] requestControls) throws NamingException {
        final Context context = this.getDelegate();
        return new RetryingLdapContext(this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Context newDelegate() throws NamingException {
                return ((LdapContext)context).newInstance(requestControls);
            }
        };
    }

    @Override
    public void reconnect(final Control[] connCtls) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Object operation() throws NamingException {
                ((LdapContext)RetryingLdapContext.this.getDelegate()).reconnect(connCtls);
                return null;
            }
        }.perform();
    }

    @Override
    public void setRequestControls(final Control[] requestControls) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Object operation() throws NamingException {
                ((LdapContext)RetryingLdapContext.this.getDelegate()).setRequestControls(requestControls);
                return null;
            }
        }.perform();
    }
}

