/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import org.apache.james.util.retry.api.ExceptionRetryingProxy;
import org.apache.james.util.retry.api.RetrySchedule;
import org.apache.james.util.retry.naming.LoggingRetryHandler;
import org.slf4j.Logger;

public abstract class RetryingContext
implements Context,
ExceptionRetryingProxy {
    public static final Class<?>[] DEFAULT_EXCEPTION_CLASSES = new Class[]{CommunicationException.class, ServiceUnavailableException.class};
    private Context _delegate = null;
    private RetrySchedule _schedule = null;
    private int _maxRetries = 0;
    private Logger _logger = null;

    private RetryingContext() {
    }

    public RetryingContext(RetrySchedule schedule, int maxRetries, Logger logger) throws NamingException {
        this(DEFAULT_EXCEPTION_CLASSES, schedule, maxRetries, logger);
    }

    public RetryingContext(Class<?>[] exceptionClasses, RetrySchedule schedule, int maxRetries, Logger logger) throws NamingException {
        this();
        this._schedule = schedule;
        this._maxRetries = maxRetries;
        this._logger = logger;
        this._delegate = (Context)new LoggingRetryHandler(exceptionClasses, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws Exception {
                return RetryingContext.this.newDelegate();
            }
        }.perform();
    }

    @Override
    public Object addToEnvironment(final String propName, final Object propVal) throws NamingException {
        return new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().addToEnvironment(propName, propVal);
            }
        }.perform();
    }

    @Override
    public void bind(final Name name, final Object obj) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().bind(name, obj);
                return null;
            }
        }.perform();
    }

    @Override
    public void bind(final String name, final Object obj) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().bind(name, obj);
                return null;
            }
        }.perform();
    }

    @Override
    public void close() throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().close();
                return null;
            }
        }.perform();
    }

    @Override
    public Name composeName(final Name name, final Name prefix) throws NamingException {
        return (Name)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().composeName(name, prefix);
            }
        }.perform();
    }

    @Override
    public String composeName(final String name, final String prefix) throws NamingException {
        return (String)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().composeName(name, prefix);
            }
        }.perform();
    }

    @Override
    public Context createSubcontext(final Name name) throws NamingException {
        final Context context = this.getDelegate();
        return new RetryingContext(this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Context newDelegate() throws NamingException {
                return context.createSubcontext(name);
            }
        };
    }

    @Override
    public Context createSubcontext(final String name) throws NamingException {
        final Context context = this.getDelegate();
        return new RetryingContext(this.getSchedule(), this.getMaxRetries(), this.getLogger()){

            @Override
            public Context newDelegate() throws NamingException {
                return context.createSubcontext(name);
            }
        };
    }

    @Override
    public void destroySubcontext(final Name name) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().destroySubcontext(name);
                return null;
            }
        }.perform();
    }

    @Override
    public void destroySubcontext(final String name) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().destroySubcontext(name);
                return null;
            }
        }.perform();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return (Hashtable)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().getEnvironment();
            }
        }.perform();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return (String)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().getNameInNamespace();
            }
        }.perform();
    }

    @Override
    public NameParser getNameParser(final Name name) throws NamingException {
        return (NameParser)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().getNameParser(name);
            }
        }.perform();
    }

    @Override
    public NameParser getNameParser(final String name) throws NamingException {
        return (NameParser)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().getNameParser(name);
            }
        }.perform();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(final Name name) throws NamingException {
        return (NamingEnumeration)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().list(name);
            }
        }.perform();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(final String name) throws NamingException {
        return (NamingEnumeration)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().list(name);
            }
        }.perform();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(final Name name) throws NamingException {
        return (NamingEnumeration)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().listBindings(name);
            }
        }.perform();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(final String name) throws NamingException {
        return (NamingEnumeration)new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().listBindings(name);
            }
        }.perform();
    }

    @Override
    public Object lookup(final Name name) throws NamingException {
        return new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().lookup(name);
            }
        }.perform();
    }

    @Override
    public Object lookup(final String name) throws NamingException {
        return new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().lookup(name);
            }
        }.perform();
    }

    @Override
    public Object lookupLink(final Name name) throws NamingException {
        return new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().lookupLink(name);
            }
        }.perform();
    }

    @Override
    public Object lookupLink(final String name) throws NamingException {
        return new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().lookupLink(name);
            }
        }.perform();
    }

    @Override
    public void rebind(final Name name, final Object obj) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().rebind(name, obj);
                return null;
            }
        }.perform();
    }

    @Override
    public void rebind(final String name, final Object obj) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().rebind(name, obj);
                return null;
            }
        }.perform();
    }

    @Override
    public Object removeFromEnvironment(final String propName) throws NamingException {
        return new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                return RetryingContext.this.getDelegate().removeFromEnvironment(propName);
            }
        }.perform();
    }

    @Override
    public void rename(final Name oldName, final Name newName) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().rename(oldName, newName);
                return null;
            }
        }.perform();
    }

    @Override
    public void rename(final String oldName, final String newName) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().rename(oldName, newName);
                return null;
            }
        }.perform();
    }

    @Override
    public void unbind(final Name name) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().unbind(name);
                return null;
            }
        }.perform();
    }

    @Override
    public void unbind(final String name) throws NamingException {
        new LoggingRetryHandler(DEFAULT_EXCEPTION_CLASSES, this, this._schedule, this._maxRetries, this._logger){

            @Override
            public Object operation() throws NamingException {
                RetryingContext.this.getDelegate().unbind(name);
                return null;
            }
        }.perform();
    }

    @Override
    public Context getDelegate() {
        return this._delegate;
    }

    @Override
    public void resetDelegate() throws Exception {
        if (null != this._delegate) {
            this._delegate.close();
        }
        this._delegate = (Context)this.newDelegate();
    }

    public RetrySchedule getSchedule() {
        return this._schedule;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public Logger getLogger() {
        return this._logger;
    }
}

