/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry.naming;

import javax.naming.NamingException;
import org.apache.james.util.retry.api.ExceptionRetryingProxy;
import org.apache.james.util.retry.api.RetrySchedule;
import org.apache.james.util.retry.naming.NamingExceptionRetryHandler;
import org.slf4j.Logger;

public abstract class LoggingRetryHandler
extends NamingExceptionRetryHandler {
    private Logger _logger = null;

    public LoggingRetryHandler(Class<?>[] exceptionClasses, ExceptionRetryingProxy proxy, RetrySchedule schedule, int maxRetries, Logger logger) {
        super(exceptionClasses, proxy, schedule, maxRetries);
        this._logger = logger;
    }

    @Override
    public void postFailure(NamingException ex, int retryCount) {
        super.postFailure(ex, retryCount);
        this._logger.info("Retry failure: " + ex.getLocalizedMessage() + "\n Retrying in " + this.getRetryInterval(retryCount) / 1000L + " seconds");
    }
}

