/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry;

import org.apache.james.util.retry.api.ExceptionRetryingProxy;
import org.apache.james.util.retry.api.RetryHandler;
import org.apache.james.util.retry.api.RetrySchedule;

public abstract class ExceptionRetryHandler
implements RetryHandler {
    private Class<?>[] _exceptionClasses = null;
    private ExceptionRetryingProxy _proxy = null;
    private RetrySchedule _schedule;
    private int _maxRetries = 0;

    private ExceptionRetryHandler() {
    }

    public ExceptionRetryHandler(Class<?>[] exceptionClasses, ExceptionRetryingProxy proxy, RetrySchedule schedule, int maxRetries) {
        this();
        this._exceptionClasses = exceptionClasses;
        this._proxy = proxy;
        this._schedule = schedule;
        this._maxRetries = maxRetries;
    }

    @Override
    public Object perform() throws Exception {
        boolean success = false;
        Object result = null;
        int retryCount = 0;
        while (!success) {
            try {
                if (retryCount > 0) {
                    this._proxy.resetDelegate();
                }
                result = this.operation();
                success = true;
            }
            catch (Exception ex) {
                if (retryCount >= this._maxRetries || !this.isRetryable(ex)) {
                    throw ex;
                }
                this.postFailure(ex, retryCount);
                try {
                    Thread.sleep(this.getRetryInterval(retryCount));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                retryCount = this._maxRetries < 0 ? this._maxRetries : retryCount + 1;
            }
        }
        return result;
    }

    private boolean isRetryable(Throwable ex) {
        boolean isRetryable = false;
        for (int i = 0; !isRetryable && i < this._exceptionClasses.length; ++i) {
            isRetryable = this._exceptionClasses[i].isInstance(ex);
        }
        return isRetryable;
    }

    @Override
    public void postFailure(Exception ex, int retryCount) {
    }

    @Override
    public abstract Object operation() throws Exception;

    public long getRetryInterval(int retryCount) {
        return this._schedule.getInterval(retryCount);
    }
}

