/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry;

import org.apache.james.util.retry.api.RetrySchedule;

public class DoublingRetrySchedule
implements RetrySchedule {
    private long _startInterval = 0L;
    private long _maxInterval = 0L;
    private long _multiplier = 1L;

    private DoublingRetrySchedule() {
    }

    public DoublingRetrySchedule(long startInterval, long maxInterval) {
        this(startInterval, maxInterval, 1);
    }

    public DoublingRetrySchedule(long startInterval, long maxInterval, int multiplier) {
        this();
        this._startInterval = Math.max(0L, startInterval);
        this._maxInterval = Math.max(0L, maxInterval);
        this._multiplier = Math.max(1, multiplier);
    }

    @Override
    public long getInterval(int index) {
        if (this._startInterval > 0L) {
            return this.getInterval(index, this._startInterval);
        }
        return index == 0 ? 0L : this.getInterval(index - 1, 1L);
    }

    private long getInterval(int index, long startInterval) {
        return this._multiplier * Math.min((long)((double)startInterval * Math.pow(2.0, index)), this._maxInterval);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DoublingRetrySchedule [startInterval=").append(this._startInterval).append(", maxInterval=").append(this._maxInterval).append(", multiplier=").append(this._multiplier).append("]");
        return builder.toString();
    }
}

