/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.concurrency;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentTestRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentTestRunner.class);
    private final int threadCount;
    private final int operationCount;
    private final CountDownLatch countDownLatch;
    private final BiConsumer biConsumer;
    private final ExecutorService executorService;
    private final List<Future> futures;

    public ConcurrentTestRunner(int threadCount, int operationCount, BiConsumer biConsumer) {
        Preconditions.checkArgument((threadCount > 0 ? 1 : 0) != 0, (Object)"Thread count should be strictly positive");
        Preconditions.checkArgument((operationCount > 0 ? 1 : 0) != 0, (Object)"Operation count should be strictly positive");
        Preconditions.checkNotNull((Object)biConsumer);
        this.threadCount = threadCount;
        this.operationCount = operationCount;
        this.countDownLatch = new CountDownLatch(threadCount);
        this.biConsumer = biConsumer;
        this.executorService = Executors.newFixedThreadPool(threadCount);
        this.futures = new ArrayList<Future>();
    }

    public ConcurrentTestRunner run() {
        for (int i = 0; i < this.threadCount; ++i) {
            this.futures.add(this.executorService.submit(new ConcurrentRunnableTask(i, this.biConsumer)));
        }
        return this;
    }

    public ConcurrentTestRunner assertNoException() throws ExecutionException, InterruptedException {
        for (Future future : this.futures) {
            future.get();
        }
        return this;
    }

    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        this.executorService.shutdown();
        return this.executorService.awaitTermination(time, unit);
    }

    private class ConcurrentRunnableTask
    implements Runnable {
        private final int threadNumber;
        private final BiConsumer biConsumer;
        private Exception exception;

        public ConcurrentRunnableTask(int threadNumber, BiConsumer biConsumer) {
            this.threadNumber = threadNumber;
            this.biConsumer = biConsumer;
        }

        @Override
        public void run() {
            this.exception = null;
            ConcurrentTestRunner.this.countDownLatch.countDown();
            for (int i = 0; i < ConcurrentTestRunner.this.operationCount; ++i) {
                try {
                    this.biConsumer.consume(this.threadNumber, i);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error caught during concurrent testing", (Throwable)e);
                    this.exception = e;
                }
            }
            if (this.exception != null) {
                throw Throwables.propagate((Throwable)this.exception);
            }
        }
    }

    public static interface BiConsumer {
        public void consume(int var1, int var2) throws Exception;
    }
}

