/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.quota;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.quota.model.JpaCurrentQuota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.store.quota.StoreCurrentQuotaManager;

public class JpaCurrentQuotaManager
implements StoreCurrentQuotaManager {
    public static final long NO_MESSAGES = 0L;
    public static final long NO_STORED_BYTES = 0L;
    private final EntityManager entityManager;

    @Inject
    public JpaCurrentQuotaManager(EntityManagerFactory entityManagerFactory) {
        this.entityManager = entityManagerFactory.createEntityManager();
    }

    public MailboxListener.ListenerType getAssociatedListenerType() {
        return MailboxListener.ListenerType.ONCE;
    }

    public long getCurrentMessageCount(QuotaRoot quotaRoot) throws MailboxException {
        JpaCurrentQuota userQuota = this.retrieveUserQuota(quotaRoot);
        if (userQuota == null) {
            return 0L;
        }
        return userQuota.getMessageCount();
    }

    public long getCurrentStorage(QuotaRoot quotaRoot) throws MailboxException {
        JpaCurrentQuota userQuota = this.retrieveUserQuota(quotaRoot);
        if (userQuota == null) {
            return 0L;
        }
        return userQuota.getSize();
    }

    public void increase(QuotaRoot quotaRoot, long count, long size) throws MailboxException {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"Counts should be positive");
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"Size should be positive");
        JpaCurrentQuota jpaCurrentQuota = (JpaCurrentQuota)Optional.fromNullable((Object)this.retrieveUserQuota(quotaRoot)).or((Object)new JpaCurrentQuota(quotaRoot.getValue(), 0L, 0L));
        this.entityManager.merge((Object)new JpaCurrentQuota(quotaRoot.getValue(), jpaCurrentQuota.getMessageCount() + count, jpaCurrentQuota.getSize() + size));
    }

    public void decrease(QuotaRoot quotaRoot, long count, long size) throws MailboxException {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"Counts should be positive");
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"Counts should be positive");
        JpaCurrentQuota jpaCurrentQuota = (JpaCurrentQuota)Optional.fromNullable((Object)this.retrieveUserQuota(quotaRoot)).or((Object)new JpaCurrentQuota(quotaRoot.getValue(), 0L, 0L));
        this.entityManager.merge((Object)new JpaCurrentQuota(quotaRoot.getValue(), jpaCurrentQuota.getMessageCount() - count, jpaCurrentQuota.getSize() - size));
    }

    private JpaCurrentQuota retrieveUserQuota(QuotaRoot quotaRoot) throws MailboxException {
        return (JpaCurrentQuota)this.entityManager.find(JpaCurrentQuota.class, (Object)quotaRoot.getValue());
    }
}

