/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.quota;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.quota.model.MaxDefaultMessageCount;
import org.apache.james.mailbox.jpa.quota.model.MaxDefaultStorage;
import org.apache.james.mailbox.jpa.quota.model.MaxUserMessageCount;
import org.apache.james.mailbox.jpa.quota.model.MaxUserStorage;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;

public class JPAPerUserMaxQuotaManager
implements MaxQuotaManager {
    private final EntityManager entityManager;

    @Inject
    public JPAPerUserMaxQuotaManager(EntityManagerFactory entityManagerFactory) {
        this.entityManager = entityManagerFactory.createEntityManager();
    }

    public void setMaxStorage(QuotaRoot quotaRoot, long maxStorageQuota) throws MailboxException {
        this.entityManager.getTransaction().begin();
        this.entityManager.merge((Object)new MaxUserStorage(quotaRoot.getValue(), maxStorageQuota));
        this.entityManager.getTransaction().commit();
    }

    public void setMaxMessage(QuotaRoot quotaRoot, long maxMessageCount) throws MailboxException {
        this.entityManager.getTransaction().begin();
        this.entityManager.merge((Object)new MaxUserMessageCount(quotaRoot.getValue(), maxMessageCount));
        this.entityManager.getTransaction().commit();
    }

    public void setDefaultMaxStorage(long defaultMaxStorage) throws MailboxException {
        this.entityManager.getTransaction().begin();
        this.entityManager.merge((Object)new MaxDefaultStorage(defaultMaxStorage));
        this.entityManager.getTransaction().commit();
    }

    public void setDefaultMaxMessage(long defaultMaxMessageCount) throws MailboxException {
        this.entityManager.getTransaction().begin();
        this.entityManager.merge((Object)new MaxDefaultMessageCount(defaultMaxMessageCount));
        this.entityManager.getTransaction().commit();
    }

    public long getDefaultMaxStorage() throws MailboxException {
        MaxDefaultStorage storedValue = (MaxDefaultStorage)this.entityManager.find(MaxDefaultStorage.class, (Object)"default_key");
        if (storedValue == null) {
            return -1L;
        }
        return storedValue.getValue();
    }

    public long getDefaultMaxMessage() throws MailboxException {
        MaxDefaultMessageCount storedValue = (MaxDefaultMessageCount)this.entityManager.find(MaxDefaultMessageCount.class, (Object)"default_key");
        if (storedValue == null) {
            return -1L;
        }
        return storedValue.getValue();
    }

    public long getMaxStorage(QuotaRoot quotaRoot) throws MailboxException {
        MaxUserStorage storedValue = (MaxUserStorage)this.entityManager.find(MaxUserStorage.class, (Object)quotaRoot.getValue());
        if (storedValue == null) {
            return this.getDefaultMaxStorage();
        }
        return storedValue.getValue();
    }

    public long getMaxMessage(QuotaRoot quotaRoot) throws MailboxException {
        MaxUserMessageCount storedValue = (MaxUserMessageCount)this.entityManager.find(MaxUserMessageCount.class, (Object)quotaRoot.getValue());
        if (storedValue == null) {
            return this.getDefaultMaxMessage();
        }
        return storedValue.getValue();
    }
}

