/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import javax.inject.Inject;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxManager;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.model.openjpa.EncryptDecryptHelper;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMessageManager;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;

public class OpenJPAMailboxManager
extends JPAMailboxManager {
    private final OpenJPAMessageManager.AdvancedFeature feature;

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, boolean useStreaming, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, int annotationLimit, int annotationLimitSize) {
        super(mapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory, annotationLimit, annotationLimitSize);
        this.feature = useStreaming ? OpenJPAMessageManager.AdvancedFeature.Streaming : OpenJPAMessageManager.AdvancedFeature.None;
    }

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, String encryptPass, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory) {
        super(mapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory);
        if (encryptPass != null) {
            EncryptDecryptHelper.init(encryptPass);
            this.feature = OpenJPAMessageManager.AdvancedFeature.Encryption;
        } else {
            this.feature = OpenJPAMessageManager.AdvancedFeature.None;
        }
    }

    @Inject
    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory) {
        this(mapperFactory, authenticator, authorizator, (MailboxPathLocker)new JVMMailboxPathLocker(), false, aclResolver, groupMembershipResolver, messageParser, messageIdFactory, 10, 1024);
    }

    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, int annotationLimit, int annotationLimitSize) {
        this(mapperFactory, authenticator, authorizator, (MailboxPathLocker)new JVMMailboxPathLocker(), false, aclResolver, groupMembershipResolver, messageParser, messageIdFactory, annotationLimit, annotationLimitSize);
    }

    protected StoreMessageManager createMessageManager(Mailbox mailboxRow, MailboxSession session) throws MailboxException {
        return new OpenJPAMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventDispatcher(), this.getLocker(), mailboxRow, this.feature, this.getAclResolver(), this.getGroupMembershipResolver(), this.getQuotaManager(), this.getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.getBatchSizes());
    }
}

