/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.google.common.base.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.store.mail.AbstractLockingUidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JPAUidProvider
extends AbstractLockingUidProvider {
    private final EntityManagerFactory factory;

    @Inject
    public JPAUidProvider(MailboxPathLocker locker, EntityManagerFactory factory) {
        super(locker);
        this.factory = factory;
    }

    public Optional<MessageUid> lastUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            long uid = (Long)manager.createNamedQuery("findLastUid").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
            manager.getTransaction().commit();
            if (uid == 0L) {
                Optional optional = Optional.absent();
                return optional;
            }
            Optional optional = Optional.of((Object)MessageUid.of((long)uid));
            return optional;
        }
        catch (PersistenceException e) {
            if (manager != null && manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            throw new MailboxException("Unable to get last uid for mailbox " + mailbox, (Throwable)e);
        }
        finally {
            if (manager != null) {
                manager.close();
            }
        }
    }

    protected MessageUid lockedNextUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, (Object)mailboxId.getRawId());
            long uid = m.consumeUid();
            manager.persist((Object)m);
            manager.getTransaction().commit();
            MessageUid messageUid = MessageUid.of((long)uid);
            return messageUid;
        }
        catch (PersistenceException e) {
            if (manager != null && manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            throw new MailboxException("Unable to save next uid for mailbox " + mailbox, (Throwable)e);
        }
        finally {
            if (manager != null) {
                manager.close();
            }
        }
    }
}

