/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMailboxMessage;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageUtils;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.utils.ApplicableFlagCalculator;
import org.apache.openjpa.persistence.ArgumentException;

public class JPAMessageMapper
extends JPATransactionalMapper
implements MessageMapper {
    private static final int UNLIMIT_MAX_SIZE = -1;
    private static final int UNLIMITED = -1;
    private static final Function<MailboxMessage, MessageUid> TO_UID = new Function<MailboxMessage, MessageUid>(){

        public MessageUid apply(MailboxMessage mailboxMessage) {
            return mailboxMessage.getUid();
        }
    };
    private final MessageUtils messageMetadataMapper;

    public JPAMessageMapper(MailboxSession mailboxSession, UidProvider uidProvider, ModSeqProvider modSeqProvider, EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
        this.messageMetadataMapper = new MessageUtils(mailboxSession, uidProvider, modSeqProvider);
    }

    public MailboxCounters getMailboxCounters(Mailbox mailbox) throws MailboxException {
        return MailboxCounters.builder().count(this.countMessagesInMailbox(mailbox)).unseen(this.countUnseenMessagesInMailbox(mailbox)).build();
    }

    public Iterator<MessageUid> listAllMessageUids(Mailbox mailbox) throws MailboxException {
        return Iterators.transform(this.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, -1), TO_UID);
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType fType, int max) throws MailboxException {
        try {
            List<MailboxMessage> results;
            MessageUid from = set.getUidFrom();
            MessageUid to = set.getUidTo();
            MessageRange.Type type = set.getType();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            switch (type) {
                default: {
                    results = this.findMessagesInMailbox(mailboxId, max);
                    break;
                }
                case FROM: {
                    results = this.findMessagesInMailboxAfterUID(mailboxId, from, max);
                    break;
                }
                case ONE: {
                    results = this.findMessagesInMailboxWithUID(mailboxId, from);
                    break;
                }
                case RANGE: {
                    results = this.findMessagesInMailboxBetweenUIDs(mailboxId, from, to, max);
                }
            }
            return results.iterator();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            return (Long)this.getEntityManager().createNamedQuery("countMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of messages failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            return (Long)this.getEntityManager().createNamedQuery("countUnseenMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of useen messages failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        try {
            AbstractJPAMailboxMessage jpaMessage = (AbstractJPAMailboxMessage)this.getEntityManager().find(AbstractJPAMailboxMessage.class, (Object)this.buildKey(mailbox, message));
            this.getEntityManager().remove((Object)jpaMessage);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of message " + message + " failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    private AbstractJPAMailboxMessage.MailboxIdUidKey buildKey(Mailbox mailbox, MailboxMessage message) {
        JPAId mailboxId = (JPAId)mailbox.getMailboxId();
        AbstractJPAMailboxMessage.MailboxIdUidKey key = new AbstractJPAMailboxMessage.MailboxIdUidKey();
        key.mailbox = mailboxId.getRawId();
        key.uid = message.getUid().asLong();
        return key;
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            Query query = this.getEntityManager().createNamedQuery("findUnseenMessagesInMailboxOrderByUid").setParameter("idParam", (Object)mailboxId.getRawId());
            query.setMaxResults(1);
            List result = query.getResultList();
            if (result.isEmpty()) {
                return null;
            }
            return ((MailboxMessage)result.get(0)).getUid();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of first unseen message failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            Query query = this.getEntityManager().createNamedQuery("findRecentMessageUidsInMailbox").setParameter("idParam", (Object)mailboxId.getRawId());
            List resultList = query.getResultList();
            ImmutableList.Builder results = ImmutableList.builder();
            Iterator iterator = resultList.iterator();
            while (iterator.hasNext()) {
                long result = (Long)iterator.next();
                results.add((Object)MessageUid.of((long)result));
            }
            return results.build();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of recent messages failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public Map<MessageUid, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox mailbox, MessageRange set) throws MailboxException {
        try {
            Map<MessageUid, MessageMetaData> data;
            MessageUid from = set.getUidFrom();
            MessageUid to = set.getUidTo();
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            switch (set.getType()) {
                case ONE: {
                    List<MailboxMessage> results = this.findDeletedMessagesInMailboxWithUID(mailboxId, from);
                    data = this.createMetaData(results);
                    this.deleteDeletedMessagesInMailboxWithUID(mailboxId, from);
                    break;
                }
                case RANGE: {
                    List<MailboxMessage> results = this.findDeletedMessagesInMailboxBetweenUIDs(mailboxId, from, to);
                    data = this.createMetaData(results);
                    this.deleteDeletedMessagesInMailboxBetweenUIDs(mailboxId, from, to);
                    break;
                }
                case FROM: {
                    List<MailboxMessage> results = this.findDeletedMessagesInMailboxAfterUID(mailboxId, from);
                    data = this.createMetaData(results);
                    this.deleteDeletedMessagesInMailboxAfterUID(mailboxId, from);
                    break;
                }
                default: {
                    List<MailboxMessage> results = this.findDeletedMessagesInMailbox(mailboxId);
                    this.deleteDeletedMessagesInMailbox(mailboxId);
                    data = this.createMetaData(results);
                }
            }
            return data;
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        throw new UnsupportedOperationException("Not implemented - see https://issues.apache.org/jira/browse/IMAP-370");
    }

    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.messageMetadataMapper.enrichMessage(mailbox, message);
        return this.save(mailbox, message);
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) throws MailboxException {
        Iterator<MailboxMessage> messages = this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, -1);
        MessageUtils.MessageChangedFlags messageChangedFlags = this.messageMetadataMapper.updateFlags(mailbox, flagsUpdateCalculator, messages);
        for (MailboxMessage mailboxMessage : messageChangedFlags.getChangedFlags()) {
            this.save(mailbox, mailboxMessage);
        }
        return messageChangedFlags.getUpdatedFlags();
    }

    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        return this.copy(mailbox, this.messageMetadataMapper.nextUid(mailbox), this.messageMetadataMapper.nextModSeq(mailbox), original);
    }

    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.messageMetadataMapper.getLastUid(mailbox);
    }

    public long getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.messageMetadataMapper.getHighestModSeq(mailbox);
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        int maxBatchSize = -1;
        return new ApplicableFlagCalculator(this.findMessagesInMailbox((JPAId)mailbox.getMailboxId(), maxBatchSize)).computeApplicableFlags();
    }

    private MessageMetaData copy(Mailbox mailbox, MessageUid uid, long modSeq, MailboxMessage original) throws MailboxException {
        JPAMailbox currentMailbox = JPAMailbox.from(mailbox);
        AbstractJPAMailboxMessage copy = original instanceof JPAStreamingMailboxMessage ? new JPAStreamingMailboxMessage(currentMailbox, uid, modSeq, original) : (original instanceof JPAEncryptedMailboxMessage ? new JPAEncryptedMailboxMessage(currentMailbox, uid, modSeq, original) : new JPAMailboxMessage(currentMailbox, uid, modSeq, original));
        return this.save(mailbox, copy);
    }

    protected MessageMetaData save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            JPAMailbox currentMailbox = (JPAMailbox)this.getEntityManager().find(JPAMailbox.class, (Object)mailboxId.getRawId());
            if (message instanceof AbstractJPAMailboxMessage) {
                ((AbstractJPAMailboxMessage)message).setMailbox(currentMailbox);
                this.getEntityManager().persist((Object)message);
                return new SimpleMessageMetaData(message);
            }
            JPAMailboxMessage persistData = new JPAMailboxMessage(currentMailbox, message.getUid(), message.getModSeq(), message);
            persistData.setFlags(message.createFlags());
            this.getEntityManager().persist((Object)persistData);
            return new SimpleMessageMetaData((MailboxMessage)persistData);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, (Throwable)e);
        }
        catch (ArgumentException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findMessagesInMailboxAfterUID(JPAId mailboxId, MessageUid from, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxAfterUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<MailboxMessage> findMessagesInMailboxWithUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailboxWithUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).setMaxResults(1).getResultList();
    }

    private List<MailboxMessage> findMessagesInMailboxBetweenUIDs(JPAId mailboxId, MessageUid from, MessageUid to, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxBetweenUIDs").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("fromParam", (Object)from.asLong()).setParameter("toParam", (Object)to.asLong());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<MailboxMessage> findMessagesInMailbox(JPAId mailboxId, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private Map<MessageUid, MessageMetaData> createMetaData(List<MailboxMessage> uids) {
        HashMap<MessageUid, MessageMetaData> data = new HashMap<MessageUid, MessageMetaData>();
        for (MailboxMessage m : uids) {
            data.put(m.getUid(), (MessageMetaData)new SimpleMessageMetaData(m));
        }
        return data;
    }

    private int deleteDeletedMessagesInMailbox(JPAId mailboxId) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxAfterUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxAfterUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxWithUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxWithUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).executeUpdate();
    }

    private int deleteDeletedMessagesInMailboxBetweenUIDs(JPAId mailboxId, MessageUid from, MessageUid to) {
        return this.getEntityManager().createNamedQuery("deleteDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("fromParam", (Object)from.asLong()).setParameter("toParam", (Object)to.asLong()).executeUpdate();
    }

    private List<MailboxMessage> findDeletedMessagesInMailbox(JPAId mailboxId) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).getResultList();
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxAfterUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxAfterUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).getResultList();
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxWithUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxWithUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).setMaxResults(1).getResultList();
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxBetweenUIDs(JPAId mailboxId, MessageUid from, MessageUid to) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("fromParam", (Object)from.asLong()).setParameter("toParam", (Object)to.asLong()).getResultList();
    }
}

