/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotation;
import org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotationId;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAAnnotationMapper
extends JPATransactionalMapper
implements AnnotationMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPAAnnotationMapper.class);
    public static final Function<JPAMailboxAnnotation, MailboxAnnotation> READ_ROW = new Function<JPAMailboxAnnotation, MailboxAnnotation>(){

        public MailboxAnnotation apply(JPAMailboxAnnotation input) {
            return MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey(input.getKey()), (String)input.getValue());
        }
    };

    public JPAAnnotationMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        JPAId jpaId = (JPAId)mailboxId;
        return Lists.transform((List)this.getEntityManager().createNamedQuery("retrieveAllAnnotations", JPAMailboxAnnotation.class).setParameter("idParam", (Object)jpaId.getRawId()).getResultList(), READ_ROW);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        try {
            final JPAId jpaId = (JPAId)mailboxId;
            return ImmutableList.copyOf((Iterable)Iterables.transform(keys, (Function)new Function<MailboxAnnotationKey, MailboxAnnotation>(){

                public MailboxAnnotation apply(MailboxAnnotationKey input) {
                    return (MailboxAnnotation)READ_ROW.apply(JPAAnnotationMapper.this.getEntityManager().createNamedQuery("retrieveByKey", JPAMailboxAnnotation.class).setParameter("idParam", (Object)jpaId.getRawId()).setParameter("keyParam", (Object)input.asString()).getSingleResult());
                }
            }));
        }
        catch (NoResultException e) {
            return ImmutableList.of();
        }
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.getFilteredLikes((JPAId)mailboxId, keys, new Function<MailboxAnnotationKey, Predicate<MailboxAnnotation>>(){

            public Predicate<MailboxAnnotation> apply(final MailboxAnnotationKey key) {
                return new Predicate<MailboxAnnotation>(){

                    public boolean apply(MailboxAnnotation input) {
                        return key.isParentOrIsEqual(input.getKey());
                    }
                };
            }
        });
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.getFilteredLikes((JPAId)mailboxId, keys, new Function<MailboxAnnotationKey, Predicate<MailboxAnnotation>>(){

            public Predicate<MailboxAnnotation> apply(final MailboxAnnotationKey key) {
                return new Predicate<MailboxAnnotation>(){

                    public boolean apply(MailboxAnnotation input) {
                        return key.isAncestorOrIsEqual(input.getKey());
                    }
                };
            }
        });
    }

    private List<MailboxAnnotation> getFilteredLikes(final JPAId jpaId, Set<MailboxAnnotationKey> keys, final Function<MailboxAnnotationKey, Predicate<MailboxAnnotation>> predicateFunction) {
        try {
            return this.flatMapToList(Iterables.transform(keys, (Function)new Function<MailboxAnnotationKey, List<MailboxAnnotation>>(){

                public List<MailboxAnnotation> apply(MailboxAnnotationKey key) {
                    return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)JPAAnnotationMapper.this.getEntityManager().createNamedQuery("retrieveByKeyLike", JPAMailboxAnnotation.class).setParameter("idParam", (Object)jpaId.getRawId()).setParameter("keyParam", (Object)(key.asString() + '%')).getResultList(), READ_ROW), (Predicate)((Predicate)predicateFunction.apply((Object)key))));
                }
            }));
        }
        catch (NoResultException e) {
            return ImmutableList.of();
        }
    }

    private List<MailboxAnnotation> flatMapToList(Iterable<List<MailboxAnnotation>> likes) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (List<MailboxAnnotation> mailboxAnnotations : likes) {
            resultBuilder.addAll(mailboxAnnotations);
        }
        return resultBuilder.build();
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        try {
            JPAId jpaId = (JPAId)mailboxId;
            JPAMailboxAnnotation jpaMailboxAnnotation = (JPAMailboxAnnotation)this.getEntityManager().find(JPAMailboxAnnotation.class, (Object)new JPAMailboxAnnotationId(jpaId.getRawId(), key.asString()));
            this.getEntityManager().remove((Object)jpaMailboxAnnotation);
        }
        catch (NoResultException e) {
            LOGGER.debug("Mailbox annotation not found for ID {} and key {}", (Object)mailboxId.serialize(), (Object)key.asString());
        }
        catch (PersistenceException pe) {
            throw Throwables.propagate((Throwable)pe);
        }
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        Preconditions.checkArgument((!mailboxAnnotation.isNil() ? 1 : 0) != 0);
        JPAId jpaId = (JPAId)mailboxId;
        if (this.getAnnotationsByKeys(mailboxId, (Set<MailboxAnnotationKey>)ImmutableSet.of((Object)mailboxAnnotation.getKey())).isEmpty()) {
            this.getEntityManager().persist((Object)new JPAMailboxAnnotation(jpaId.getRawId(), mailboxAnnotation.getKey().asString(), (String)mailboxAnnotation.getValue().orNull()));
        } else {
            ((JPAMailboxAnnotation)this.getEntityManager().find(JPAMailboxAnnotation.class, (Object)new JPAMailboxAnnotationId(jpaId.getRawId(), mailboxAnnotation.getKey().asString()))).setValue((String)mailboxAnnotation.getValue().orNull());
        }
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        JPAId jpaId = (JPAId)mailboxId;
        Optional row = Optional.fromNullable((Object)this.getEntityManager().find(JPAMailboxAnnotation.class, (Object)new JPAMailboxAnnotationId(jpaId.getRawId(), mailboxAnnotation.getKey().asString())));
        return row.isPresent();
    }

    public int countAnnotations(MailboxId mailboxId) {
        try {
            JPAId jpaId = (JPAId)mailboxId;
            return ((Long)this.getEntityManager().createNamedQuery("countAnnotationsInMailbox").setParameter("idParam", (Object)jpaId.getRawId()).getSingleResult()).intValue();
        }
        catch (PersistenceException pe) {
            throw Throwables.propagate((Throwable)pe);
        }
    }
}

