/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import java.util.EnumSet;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.transaction.Mapper;

public abstract class JPAMailboxManager
extends StoreMailboxManager {
    public JPAMailboxManager(JPAMailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory) {
        super((MailboxSessionMapperFactory)mailboxSessionMapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory);
    }

    public JPAMailboxManager(JPAMailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, int limitAnnotation, int limitAnnotationSize) {
        super((MailboxSessionMapperFactory)mailboxSessionMapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory, limitAnnotation, limitAnnotationSize);
    }

    protected Mailbox doCreateMailbox(MailboxPath path, MailboxSession session) throws MailboxException {
        return new JPAMailbox(path, this.randomUidValidity());
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.of(MailboxManager.MailboxCapabilities.UserFlag, MailboxManager.MailboxCapabilities.Namespace, MailboxManager.MailboxCapabilities.Annotation);
    }

    public void deleteEverything(MailboxSession mailboxSession) throws MailboxException {
        final JPAMailboxMapper mapper = (JPAMailboxMapper)this.getMapperFactory().getMailboxMapper(mailboxSession);
        mapper.execute((Mapper.Transaction)new Mapper.VoidTransaction(){

            public void runVoid() throws MailboxException {
                mapper.deleteAllMemberships();
            }
        });
        mapper.execute((Mapper.Transaction)new Mapper.VoidTransaction(){

            public void runVoid() throws MailboxException {
                mapper.deleteAllMailboxes();
            }
        });
    }
}

