/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.logger;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.metrics.logger.DefaultMetricFactory;

public class DefaultTimeMetric
implements TimeMetric {
    private final String name;
    private final Stopwatch stopwatch;

    public DefaultTimeMetric(String name) {
        this.name = name;
        this.stopwatch = Stopwatch.createStarted();
    }

    public String name() {
        return this.name;
    }

    public long stopAndPublish() {
        long elapsed = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        DefaultMetricFactory.LOGGER.info("Time spent in " + this.name + ": " + elapsed + " ms.");
        return elapsed;
    }
}

