/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

public class DigestUtil {
    public static void main(String[] args) {
        String alg = "SHA";
        boolean file = false;
        if (args.length == 0 || args.length > 4) {
            DigestUtil.printUsage();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String currArg = args[i].toLowerCase(Locale.US);
            if (currArg.equals("-help") || currArg.equals("-usage")) {
                DigestUtil.printUsage();
                return;
            }
            if (currArg.equals("-alg")) {
                alg = args[i + 1];
            }
            if (!currArg.equals("-file")) continue;
            file = true;
        }
        if (file) {
            DigestUtil.digestFile(args[args.length - 1], alg);
        } else {
            try {
                String hash = DigestUtil.digestString(args[args.length - 1], alg);
                System.out.println("Hash is: " + hash);
            }
            catch (NoSuchAlgorithmException nsae) {
                System.out.println("No such algorithm available");
            }
        }
    }

    public static void printUsage() {
        System.out.println("Usage: java org.apache.james.security.DigestUtil [-alg algorithm] [-file] filename|string");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void digestFile(String filename, String algorithm) {
        byte[] b = new byte[65536];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            fis = new FileInputStream(filename);
            while (fis.available() > 0) {
                int read = fis.read(b);
                md.update(b, 0, read);
            }
            byte[] digest = md.digest();
            String fileNameBuffer = filename + "." + algorithm;
            fos = new FileOutputStream(fileNameBuffer);
            OutputStream encodedStream = MimeUtility.encode((OutputStream)fos, (String)"base64");
            encodedStream.write(digest);
            fos.flush();
        }
        catch (Exception e) {
            System.out.println("Error computing Digest: " + e);
        }
        finally {
            try {
                fis.close();
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String digestString(String pass, String algorithm) throws NoSuchAlgorithmException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(pass.getBytes("iso-8859-1"));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream encodedStream = MimeUtility.encode((OutputStream)bos, (String)"base64");
            encodedStream.write(digest);
            return bos.toString("iso-8859-1");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Fatal error: " + ioe);
        }
        catch (MessagingException me) {
            throw new RuntimeException("Fatal error: " + (Object)((Object)me));
        }
    }

    private DigestUtil() {
    }
}

