/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.inject.Inject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.MailAddress;
import org.slf4j.Logger;

public abstract class AbstractUsersRepository
implements UsersRepository,
LogEnabled,
Configurable {
    private DomainList domainList;
    private boolean virtualHosting;
    private Logger logger;
    private Optional<String> administratorId;

    protected Logger getLogger() {
        return this.logger;
    }

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.virtualHosting = configuration.getBoolean("enableVirtualHosting", this.getDefaultVirtualHostingValue());
        this.administratorId = Optional.fromNullable((Object)configuration.getString("administratorId"));
        this.doConfigure(configuration);
    }

    protected boolean getDefaultVirtualHostingValue() {
        return false;
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    public void setEnableVirtualHosting(boolean virtualHosting) {
        this.virtualHosting = virtualHosting;
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    protected void isValidUsername(String username) throws UsersRepositoryException {
        block6: {
            int i = username.indexOf("@");
            if (this.supportVirtualHosting()) {
                if (i == -1) {
                    throw new UsersRepositoryException("Given Username needs to contain a @domainpart");
                }
                String domain = username.substring(i + 1);
                try {
                    if (!this.domainList.containsDomain(domain)) {
                        throw new UsersRepositoryException("Domain does not exist in DomainList");
                    }
                    break block6;
                }
                catch (DomainListException e) {
                    throw new UsersRepositoryException("Unable to query DomainList", (Throwable)e);
                }
            }
            if (i != -1) {
                throw new UsersRepositoryException("Given Username contains a @domainpart but virtualhosting support is disabled");
            }
        }
    }

    public void addUser(String username, String password) throws UsersRepositoryException {
        if (this.contains(username)) {
            throw new AlreadyExistInUsersRepositoryException("User with username " + username + " already exists!");
        }
        this.isValidUsername(username);
        this.doAddUser(username, password);
    }

    public boolean supportVirtualHosting() {
        return this.virtualHosting;
    }

    protected abstract void doAddUser(String var1, String var2) throws UsersRepositoryException;

    public String getUser(MailAddress mailAddress) throws UsersRepositoryException {
        if (this.supportVirtualHosting()) {
            return mailAddress.asString();
        }
        return mailAddress.getLocalPart();
    }

    @VisibleForTesting
    void setAdministratorId(Optional<String> username) {
        this.administratorId = username;
    }

    public boolean isAdministrator(String username) throws UsersRepositoryException {
        if (this.administratorId.isPresent()) {
            return ((String)this.administratorId.get()).equals(username);
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }
}

