/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.repository.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader m_classLoader;

    public ClassLoaderObjectInputStream(ClassLoader classLoader, InputStream inputStream) throws IOException {
        super(inputStream);
        this.m_classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName(objectStreamClass.getName(), false, this.m_classLoader);
        if (null != clazz) {
            return clazz;
        }
        return super.resolveClass(objectStreamClass);
    }
}

