/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.lib;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.api.DomainListManagementMBean;

public class DomainListManagement
extends StandardMBean
implements DomainListManagementMBean {
    private DomainList domainList;

    public DomainListManagement() throws NotCompliantMBeanException {
        super(DomainListManagementMBean.class);
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public void addDomain(String domain) throws Exception {
        try {
            this.domainList.addDomain(domain);
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public boolean containsDomain(String domain) throws Exception {
        try {
            return this.domainList.containsDomain(domain);
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public List<String> getDomains() throws Exception {
        try {
            return ImmutableList.copyOf((Collection)this.domainList.getDomains());
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeDomain(String domain) throws Exception {
        try {
            this.domainList.removeDomain(domain);
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public String getDefaultDomain() throws Exception {
        try {
            return this.domainList.getDefaultDomain();
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }
}

