/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.lib;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDomainList
implements DomainList,
LogEnabled,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDomainList.class);
    protected static final String LOCALHOST = "localhost";
    private DNSService dns;
    private boolean autoDetect = true;
    private boolean autoDetectIP = true;
    private Logger logger;
    private String defaultDomain;

    @Inject
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.configureDefaultDomain(config);
        this.setAutoDetect(config.getBoolean("autodetect", true));
        this.setAutoDetectIP(config.getBoolean("autodetectIP", true));
    }

    @VisibleForTesting
    void configureDefaultDomain(HierarchicalConfiguration config) throws ConfigurationException {
        try {
            this.defaultDomain = config.getString("defaultDomain", LOCALHOST);
            String hostName = InetAddress.getLocalHost().getHostName();
            if (this.mayChangeDefaultDomain()) {
                this.setDefaultDomain(hostName);
            }
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to retrieve hostname.", (Throwable)e);
        }
        catch (DomainListException e) {
            LOGGER.error("An error occured while creating the default domain", (Throwable)e);
        }
    }

    private boolean mayChangeDefaultDomain() {
        return LOCALHOST.equals(this.defaultDomain);
    }

    private void setDefaultDomain(String defaultDomain) throws DomainListException {
        if (!this.containsDomain(defaultDomain)) {
            this.addDomain(defaultDomain);
        }
        this.defaultDomain = defaultDomain;
    }

    public String getDefaultDomain() throws DomainListException {
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        throw new DomainListException("Null default domain. Domain list might not be configured yet.");
    }

    public List<String> getDomains() throws DomainListException {
        List<String> domains = this.getDomainListInternal();
        if (domains != null) {
            String hostName;
            ArrayList<String> mutableDomains = new ArrayList<String>(domains);
            try {
                hostName = this.getDNSServer().getHostName(this.getDNSServer().getLocalHost());
            }
            catch (UnknownHostException ue) {
                hostName = LOCALHOST;
            }
            this.getLogger().info("Local host is: " + hostName);
            if (this.autoDetect && !hostName.equals(LOCALHOST)) {
                mutableDomains.add(hostName.toLowerCase(Locale.US));
            }
            if (this.autoDetectIP) {
                mutableDomains.addAll(AbstractDomainList.getDomainsIP(mutableDomains, this.dns, this.getLogger()));
            }
            if (this.getLogger().isInfoEnabled()) {
                for (String domain : mutableDomains) {
                    this.getLogger().debug("Handling mail for: " + domain);
                }
            }
            return ImmutableList.copyOf(mutableDomains);
        }
        return ImmutableList.of();
    }

    private static List<String> getDomainsIP(List<String> domains, DNSService dns, Logger log) {
        ArrayList<String> domainIP = new ArrayList<String>();
        if (domains.size() > 0) {
            for (String domain : domains) {
                List<String> domList = AbstractDomainList.getDomainIP(domain, dns, log);
                for (String aDomList : domList) {
                    if (domainIP.contains(aDomList)) continue;
                    domainIP.add(aDomList);
                }
            }
        }
        return domainIP;
    }

    private static List<String> getDomainIP(String domain, DNSService dns, Logger log) {
        ArrayList<String> domainIP = new ArrayList<String>();
        try {
            Collection addrs = dns.getAllByName(domain);
            for (InetAddress addr : addrs) {
                String ip = addr.getHostAddress();
                if (domainIP.contains(ip)) continue;
                domainIP.add(ip);
            }
        }
        catch (UnknownHostException e) {
            log.error("Cannot get IP address(es) for " + domain);
        }
        return domainIP;
    }

    public synchronized void setAutoDetect(boolean autoDetect) {
        this.getLogger().info("Set autodetect to: " + autoDetect);
        this.autoDetect = autoDetect;
    }

    public synchronized void setAutoDetectIP(boolean autoDetectIP) {
        this.getLogger().info("Set autodetectIP to: " + autoDetectIP);
        this.autoDetectIP = autoDetectIP;
    }

    protected DNSService getDNSServer() {
        return this.dns;
    }

    protected abstract List<String> getDomainListInternal() throws DomainListException;
}

