/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ConnectionLimitUpstreamHandler
extends SimpleChannelUpstreamHandler {
    private final AtomicInteger connections = new AtomicInteger(0);
    private volatile int maxConnections = -1;

    public ConnectionLimitUpstreamHandler(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getConnections() {
        return this.connections.get();
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        int currentCount;
        if (this.maxConnections > 0 && (currentCount = this.connections.incrementAndGet()) > this.maxConnections) {
            ctx.getChannel().close();
        }
        super.channelOpen(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.maxConnections > 0) {
            this.connections.decrementAndGet();
        }
        super.channelClosed(ctx, e);
    }
}

