/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.pop3server.mailbox.MailboxAdapter;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.lib.POP3BeforeSMTPHelper;
import org.apache.james.protocols.lib.Slf4jLoggerAdapter;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPassCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.slf4j.Logger;

public class PassCmdHandler
extends AbstractPassCmdHandler {
    private MailboxManager manager;

    @Inject
    public void setMailboxManager(@Named(value="mailboxmanager") MailboxManager manager) {
        this.manager = manager;
    }

    public Response onCommand(POP3Session session, Request request) {
        Response response = super.onCommand(session, request);
        if ("+OK".equals(response.getRetCode())) {
            POP3BeforeSMTPHelper.addIPAddress((String)session.getRemoteAddress().getAddress().getHostAddress());
        }
        return response;
    }

    /*
     * Loose catch block
     */
    protected Mailbox auth(POP3Session session, String username, String password) throws Exception {
        MailboxAdapter mailboxAdapter;
        block9: {
            MailboxSession mSession = null;
            try {
                mSession = this.manager.login(session.getUser(), password, (Logger)new Slf4jLoggerAdapter(session.getLogger()));
                this.manager.startProcessingRequest(mSession);
                MailboxPath inbox = MailboxPath.inbox((MailboxSession)mSession);
                if (!this.manager.mailboxExists(inbox, mSession)) {
                    this.manager.createMailbox(inbox, mSession);
                }
                MessageManager mailbox = this.manager.getMailbox(MailboxPath.inbox((MailboxSession)mSession), mSession);
                mailboxAdapter = new MailboxAdapter(this.manager, mailbox, mSession);
                if (mSession == null) break block9;
            }
            catch (BadCredentialsException e) {
                Mailbox mailbox = null;
                return mailbox;
            }
            catch (MailboxException e2) {
                throw new IOException("Unable to access mailbox for user " + session.getUser(), e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (mSession != null) {
                    this.manager.endProcessingRequest(mSession);
                }
            }
            this.manager.endProcessingRequest(mSession);
        }
        return mailboxAdapter;
    }
}

