/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;

public class SimpleMailboxACL
implements MailboxACL {
    public static final MailboxACL.MailboxACLEntryKey ANYBODY_KEY;
    public static final MailboxACL.MailboxACLEntryKey ANYBODY_NEGATIVE_KEY;
    public static final MailboxACL.MailboxACLEntryKey AUTHENTICATED_KEY;
    public static final MailboxACL.MailboxACLEntryKey AUTHENTICATED_NEGATIVE_KEY;
    public static final MailboxACL EMPTY;
    public static final MailboxACL.MailboxACLRights FULL_RIGHTS;
    public static final MailboxACL.MailboxACLRights NO_RIGHTS;
    public static final MailboxACL OWNER_FULL_ACL;
    public static final MailboxACL OWNER_FULL_EXCEPT_ADMINISTRATION_ACL;
    public static final MailboxACL.MailboxACLEntryKey OWNER_KEY;
    public static final MailboxACL.MailboxACLEntryKey OWNER_NEGATIVE_KEY;
    private final Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> entries;

    public SimpleMailboxACL() {
        this.entries = Collections.emptyMap();
    }

    public SimpleMailboxACL(Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>[] entries) {
        if (entries != null) {
            HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> m = new HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>(entries.length + entries.length / 2 + 1);
            for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> en : entries) {
                m.put(en.getKey(), en.getValue());
            }
            this.entries = Collections.unmodifiableMap(m);
        } else {
            this.entries = Collections.emptyMap();
        }
    }

    public SimpleMailboxACL(Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> entries) {
        if (entries != null && entries.size() > 0) {
            HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> m = new HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>(entries.size() + entries.size() / 2 + 1);
            for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> en : entries.entrySet()) {
                m.put(en.getKey(), en.getValue());
            }
            this.entries = Collections.unmodifiableMap(m);
        } else {
            this.entries = Collections.emptyMap();
        }
    }

    private SimpleMailboxACL(Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> unmodifiableEntries, boolean dummy) {
        this.entries = unmodifiableEntries;
    }

    public SimpleMailboxACL(Properties props) throws UnsupportedRightException {
        HashMap<SimpleMailboxACLEntryKey, Rfc4314Rights> m = new HashMap<SimpleMailboxACLEntryKey, Rfc4314Rights>(props.size() + props.size() / 2 + 1);
        if (props != null) {
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                m.put(new SimpleMailboxACLEntryKey((String)prop.getKey()), new Rfc4314Rights((String)prop.getValue()));
            }
        }
        this.entries = Collections.unmodifiableMap(m);
    }

    public boolean equals(Object o) {
        if (o instanceof MailboxACL) {
            MailboxACL acl = (MailboxACL)o;
            Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> ens = acl.getEntries();
            return this.entries == ens || this.entries != null && this.entries.equals(ens);
        }
        return false;
    }

    @Override
    public MailboxACL apply(MailboxACL.MailboxACLCommand aclUpdate) throws UnsupportedRightException {
        switch (aclUpdate.getEditMode()) {
            case ADD: {
                return this.union(aclUpdate.getEntryKey(), aclUpdate.getRights());
            }
            case REMOVE: {
                return this.except(aclUpdate.getEntryKey(), aclUpdate.getRights());
            }
            case REPLACE: {
                return this.replace(aclUpdate.getEntryKey(), aclUpdate.getRights());
            }
        }
        throw new RuntimeException("Unknown edit mode");
    }

    @Override
    public MailboxACL except(MailboxACL other) throws UnsupportedRightException {
        if (this.entries.size() == 0) {
            return this;
        }
        Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> otherEntries = other.getEntries();
        HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> resultEntries = new HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>(this.entries);
        for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> otherEntry : otherEntries.entrySet()) {
            MailboxACL.MailboxACLEntryKey key = otherEntry.getKey();
            MailboxACL.MailboxACLRights thisRights = (MailboxACL.MailboxACLRights)resultEntries.get(key);
            if (thisRights == null) continue;
            MailboxACL.MailboxACLRights resultRights = thisRights.except(otherEntry.getValue());
            if (!resultRights.isEmpty()) {
                resultEntries.put(key, resultRights);
                continue;
            }
            resultEntries.remove(key);
        }
        return new SimpleMailboxACL(Collections.unmodifiableMap(resultEntries), true);
    }

    @Override
    public MailboxACL except(MailboxACL.MailboxACLEntryKey key, MailboxACL.MailboxACLRights mailboxACLRights) throws UnsupportedRightException {
        HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> resultEntries = new HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>(this.entries);
        MailboxACL.MailboxACLRights thisRights = (MailboxACL.MailboxACLRights)resultEntries.get(key);
        if (thisRights != null) {
            MailboxACL.MailboxACLRights resultRights = thisRights.except(mailboxACLRights);
            if (!resultRights.isEmpty()) {
                resultEntries.put(key, resultRights);
            } else {
                resultEntries.remove(key);
            }
        }
        return new SimpleMailboxACL(Collections.unmodifiableMap(resultEntries), true);
    }

    @Override
    public Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> getEntries() {
        return this.entries;
    }

    public int hashCode() {
        return this.entries == null ? 0 : this.entries.hashCode();
    }

    @Override
    public MailboxACL replace(MailboxACL.MailboxACLEntryKey key, MailboxACL.MailboxACLRights replacement) throws UnsupportedRightException {
        HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> resultEntries = new HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>(this.entries);
        if (replacement == null || replacement.isEmpty()) {
            resultEntries.remove(key);
        } else {
            resultEntries.put(key, replacement);
        }
        return new SimpleMailboxACL(Collections.unmodifiableMap(resultEntries), true);
    }

    public String toString() {
        return this.entries == null ? "" : this.entries.toString();
    }

    @Override
    public MailboxACL union(MailboxACL other) throws UnsupportedRightException {
        MailboxACL.MailboxACLEntryKey key;
        Map<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> otherEntries = other.getEntries();
        if (otherEntries.size() == 0) {
            return this;
        }
        if (this.entries.size() == 0) {
            return other;
        }
        int cnt = otherEntries.size() + this.entries.size();
        HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> resultEntries = new HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>(cnt + cnt / 2 + 1);
        for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> otherEntry : otherEntries.entrySet()) {
            key = otherEntry.getKey();
            MailboxACL.MailboxACLRights thisRights = this.entries.get(key);
            if (thisRights == null) {
                resultEntries.put(key, otherEntry.getValue());
                continue;
            }
            resultEntries.put(key, otherEntry.getValue().union(thisRights));
        }
        for (Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> thisEntry : this.entries.entrySet()) {
            key = thisEntry.getKey();
            if (resultEntries.containsKey(key)) continue;
            resultEntries.put(key, thisEntry.getValue());
        }
        return new SimpleMailboxACL(Collections.unmodifiableMap(resultEntries), true);
    }

    @Override
    public MailboxACL union(MailboxACL.MailboxACLEntryKey key, MailboxACL.MailboxACLRights mailboxACLRights) throws UnsupportedRightException {
        HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> resultEntries = new HashMap<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights>(this.entries);
        MailboxACL.MailboxACLRights thisRights = (MailboxACL.MailboxACLRights)resultEntries.get(key);
        if (thisRights == null) {
            resultEntries.put(key, mailboxACLRights);
        } else {
            resultEntries.put(key, thisRights.union(mailboxACLRights));
        }
        return new SimpleMailboxACL(Collections.unmodifiableMap(resultEntries), true);
    }

    static {
        try {
            ANYBODY_KEY = new SimpleMailboxACLEntryKey(MailboxACL.SpecialName.anybody.name(), MailboxACL.NameType.special, false);
            ANYBODY_NEGATIVE_KEY = new SimpleMailboxACLEntryKey(MailboxACL.SpecialName.anybody.name(), MailboxACL.NameType.special, true);
            AUTHENTICATED_KEY = new SimpleMailboxACLEntryKey(MailboxACL.SpecialName.authenticated.name(), MailboxACL.NameType.special, false);
            AUTHENTICATED_NEGATIVE_KEY = new SimpleMailboxACLEntryKey(MailboxACL.SpecialName.authenticated.name(), MailboxACL.NameType.special, true);
            EMPTY = new SimpleMailboxACL();
            FULL_RIGHTS = new Rfc4314Rights(true, true, true, true, true, true, true, true, true, true, true);
            NO_RIGHTS = new Rfc4314Rights();
            OWNER_KEY = new SimpleMailboxACLEntryKey(MailboxACL.SpecialName.owner.name(), MailboxACL.NameType.special, false);
            OWNER_NEGATIVE_KEY = new SimpleMailboxACLEntryKey(MailboxACL.SpecialName.owner.name(), MailboxACL.NameType.special, true);
            OWNER_FULL_ACL = new SimpleMailboxACL(new SimpleMailboxACLEntry[]{new SimpleMailboxACLEntry(OWNER_KEY, FULL_RIGHTS)});
            OWNER_FULL_EXCEPT_ADMINISTRATION_ACL = new SimpleMailboxACL(new SimpleMailboxACLEntry[]{new SimpleMailboxACLEntry(OWNER_KEY, FULL_RIGHTS.except(new Rfc4314Rights(1)))});
        }
        catch (UnsupportedRightException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SimpleMailboxACLCommand
    implements MailboxACL.MailboxACLCommand {
        private final MailboxACL.MailboxACLEntryKey key;
        private final MailboxACL.EditMode editMode;
        private final MailboxACL.MailboxACLRights rights;

        public SimpleMailboxACLCommand(MailboxACL.MailboxACLEntryKey key, MailboxACL.EditMode editMode, MailboxACL.MailboxACLRights rights) {
            this.key = key;
            this.editMode = editMode;
            this.rights = rights;
        }

        @Override
        public MailboxACL.MailboxACLEntryKey getEntryKey() {
            return this.key;
        }

        @Override
        public MailboxACL.EditMode getEditMode() {
            return this.editMode;
        }

        @Override
        public MailboxACL.MailboxACLRights getRights() {
            return this.rights;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleMailboxACLCommand)) {
                return false;
            }
            SimpleMailboxACLCommand that = (SimpleMailboxACLCommand)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            if (this.editMode != that.editMode) {
                return false;
            }
            return !(this.rights == null ? that.rights != null : !this.rights.equals(that.rights));
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.editMode != null ? this.editMode.hashCode() : 0);
            result = 31 * result + (this.rights != null ? this.rights.hashCode() : 0);
            return result;
        }
    }

    public static final class SimpleMailboxACLRight
    implements MailboxACL.MailboxACLRight {
        private final char value;

        public SimpleMailboxACLRight(char value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o instanceof MailboxACL.MailboxACLRight) {
                return ((MailboxACL.MailboxACLRight)o).getValue() == this.value;
            }
            return false;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class SimpleMailboxACLEntryKey
    implements MailboxACL.MailboxACLEntryKey {
        private final int hash;
        private final String name;
        private final MailboxACL.NameType nameType;
        private final boolean negative;

        public static SimpleMailboxACLEntryKey createGroup(String name) {
            return new SimpleMailboxACLEntryKey(name, MailboxACL.NameType.group, false);
        }

        public static SimpleMailboxACLEntryKey createGroup(String name, boolean negative) {
            return new SimpleMailboxACLEntryKey(name, MailboxACL.NameType.group, negative);
        }

        public static SimpleMailboxACLEntryKey createUser(String name) {
            return new SimpleMailboxACLEntryKey(name, MailboxACL.NameType.user, false);
        }

        public static SimpleMailboxACLEntryKey createUser(String name, boolean negative) {
            return new SimpleMailboxACLEntryKey(name, MailboxACL.NameType.user, negative);
        }

        public SimpleMailboxACLEntryKey(String serialized) {
            if (serialized == null) {
                throw new IllegalStateException("Cannot parse null to a " + this.getClass().getName());
            }
            if (serialized.length() == 0) {
                throw new IllegalStateException("Cannot parse an empty string to a " + this.getClass().getName());
            }
            int start = 0;
            if (serialized.charAt(start) == '-') {
                this.negative = true;
                ++start;
            } else {
                this.negative = false;
            }
            if (serialized.charAt(start) == '$') {
                this.nameType = MailboxACL.NameType.group;
                this.name = serialized.substring(++start);
                if (this.name.length() == 0) {
                    throw new IllegalStateException("Cannot parse a string with empty name to a " + this.getClass().getName());
                }
            } else {
                this.name = serialized.substring(start);
                if (this.name.length() == 0) {
                    throw new IllegalStateException("Cannot parse a string with empty name to a " + this.getClass().getName());
                }
                MailboxACL.NameType nt = MailboxACL.NameType.user;
                for (MailboxACL.SpecialName specialName : MailboxACL.SpecialName.values()) {
                    if (!specialName.name().equals(this.name)) continue;
                    nt = MailboxACL.NameType.special;
                    break;
                }
                this.nameType = nt;
            }
            this.hash = this.hash();
        }

        public SimpleMailboxACLEntryKey(String name, MailboxACL.NameType nameType, boolean negative) {
            if (name == null) {
                throw new NullPointerException("Provide a name for this " + this.getClass().getName());
            }
            if (nameType == null) {
                throw new NullPointerException("Provide a nameType for this " + this.getClass().getName());
            }
            this.name = name;
            this.nameType = nameType;
            this.negative = negative;
            this.hash = this.hash();
        }

        public boolean equals(Object o) {
            if (o instanceof MailboxACL.MailboxACLEntryKey) {
                MailboxACL.MailboxACLEntryKey other = (MailboxACL.MailboxACLEntryKey)o;
                return this.name.equals(other.getName()) && this.nameType.equals((Object)other.getNameType()) && this.negative == other.isNegative();
            }
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public MailboxACL.NameType getNameType() {
            return this.nameType;
        }

        private int hash() {
            int PRIME = 31;
            int hash = this.negative ? 1 : 0;
            hash = 31 * hash + this.nameType.hashCode();
            hash = 31 * hash + this.name.hashCode();
            return hash;
        }

        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean isNegative() {
            return this.negative;
        }

        @Override
        public String serialize() {
            if (!this.negative) {
                switch (this.nameType) {
                    case special: 
                    case user: {
                        return this.name;
                    }
                    case group: {
                        return new StringBuilder(this.name.length() + 1).append('$').append(this.name).toString();
                    }
                }
                throw new IllegalStateException();
            }
            StringBuilder result = new StringBuilder(this.name.length() + 2).append('-');
            switch (this.nameType) {
                case special: 
                case user: {
                    break;
                }
                case group: {
                    result.append('$');
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return result.append(this.name).toString();
        }

        public String toString() {
            return this.serialize();
        }
    }

    public static class SimpleMailboxACLEntry
    implements Map.Entry<MailboxACL.MailboxACLEntryKey, MailboxACL.MailboxACLRights> {
        private final MailboxACL.MailboxACLEntryKey key;
        private final MailboxACL.MailboxACLRights value;

        public SimpleMailboxACLEntry(MailboxACL.MailboxACLEntryKey key, MailboxACL.MailboxACLRights value) {
            this.key = key;
            this.value = value;
        }

        public SimpleMailboxACLEntry(String key, String value) throws UnsupportedRightException {
            this(new SimpleMailboxACLEntryKey(key), new Rfc4314Rights(value));
        }

        @Override
        public MailboxACL.MailboxACLEntryKey getKey() {
            return this.key;
        }

        @Override
        public MailboxACL.MailboxACLRights getValue() {
            return this.value;
        }

        @Override
        public MailboxACL.MailboxACLRights setValue(MailboxACL.MailboxACLRights value) {
            throw new UnsupportedOperationException("Fields of " + MailboxACL.MailboxACLRights.class.getName() + " are read only.");
        }
    }

    public static class Rfc4314Rights
    implements MailboxACL.MailboxACLRights {
        public static final char a_Administer = 'a';
        static final int a_Administer_MASK = 1;
        public static final MailboxACL.MailboxACLRight a_Administer_RIGHT = new SimpleMailboxACLRight('a');
        public static final char c_ObsoleteCreate = 'c';
        public static final char d_ObsoleteDelete = 'd';
        public static final char e_PerformExpunge = 'e';
        static final int e_PerformExpunge_MASK = 2;
        public static final MailboxACL.MailboxACLRight e_PerformExpunge_RIGHT = new SimpleMailboxACLRight('e');
        public static final int EMPTY_MASK = 0;
        public static final int FIELD_COUNT = 11;
        public static final char i_Insert = 'i';
        static final int i_Insert_MASK = 4;
        public static final MailboxACL.MailboxACLRight i_Insert_RIGHT = new SimpleMailboxACLRight('i');
        private static final char[] indexFlagLookup;
        private static final MailboxACL.MailboxACLRight[] indexRightLookup;
        public static final char k_CreateMailbox = 'k';
        static final int k_CreateMailbox_MASK = 8;
        public static final MailboxACL.MailboxACLRight k_CreateMailbox_RIGHT;
        public static final char l_Lookup = 'l';
        static final int l_Lookup_MASK = 16;
        public static final MailboxACL.MailboxACLRight l_Lookup_RIGHT;
        public static final char p_Post = 'p';
        static final int p_Post_MASK = 32;
        public static final MailboxACL.MailboxACLRight p_Post_RIGHT;
        public static final char r_Read = 'r';
        static final int r_Read_MASK = 64;
        public static final MailboxACL.MailboxACLRight r_Read_RIGHT;
        public static final char s_WriteSeenFlag = 's';
        static final int s_WriteSeenFlag_MASK = 128;
        public static final MailboxACL.MailboxACLRight s_WriteSeenFlag_RIGHT;
        public static final char t_DeleteMessages = 't';
        static final int t_DeleteMessages_MASK = 256;
        public static final MailboxACL.MailboxACLRight t_DeleteMessages_RIGHT;
        public static final char w_Write = 'w';
        static final int w_Write_MASK = 512;
        public static final MailboxACL.MailboxACLRight w_Write_RIGHT;
        public static final char x_DeleteMailbox = 'x';
        static final int x_DeleteMailbox_MASK = 1024;
        public static final MailboxACL.MailboxACLRight x_DeleteMailbox_RIGHT;
        private final CompatibilityMode compatibilityMode = CompatibilityMode.ckx_det;
        private final int value;

        private static int flagMaskLookup(char flag) throws UnsupportedRightException {
            switch (flag) {
                case 'a': {
                    return 1;
                }
                case 'e': {
                    return 2;
                }
                case 'i': {
                    return 4;
                }
                case 'k': {
                    return 8;
                }
                case 'l': {
                    return 16;
                }
                case 'p': {
                    return 32;
                }
                case 'r': {
                    return 64;
                }
                case 's': {
                    return 128;
                }
                case 't': {
                    return 256;
                }
                case 'w': {
                    return 512;
                }
                case 'x': {
                    return 1024;
                }
            }
            throw new UnsupportedRightException(flag);
        }

        private Rfc4314Rights() {
            this.value = 0;
        }

        public Rfc4314Rights(boolean canAdminister, boolean canCreateMailbox, boolean canDeleteMailbox, boolean canDeleteMessages, boolean canInsert, boolean canLookup, boolean canPerformExpunge, boolean canPost, boolean canRead, boolean canWrite, boolean canWriteSeenFlag) {
            int v = 0;
            if (canAdminister) {
                v |= 1;
            }
            if (canCreateMailbox) {
                v |= 8;
            }
            if (canDeleteMailbox) {
                v |= 0x400;
            }
            if (canDeleteMessages) {
                v |= 0x100;
            }
            if (canInsert) {
                v |= 4;
            }
            if (canLookup) {
                v |= 0x10;
            }
            if (canPerformExpunge) {
                v |= 2;
            }
            if (canPost) {
                v |= 0x20;
            }
            if (canRead) {
                v |= 0x40;
            }
            if (canWrite) {
                v |= 0x200;
            }
            if (canWriteSeenFlag) {
                v |= 0x80;
            }
            this.value = v;
        }

        public Rfc4314Rights(int value) throws UnsupportedRightException {
            if (value >> 11 != 0) {
                throw new UnsupportedRightException();
            }
            this.value = value;
        }

        public Rfc4314Rights(MailboxACL.MailboxACLRight right) throws UnsupportedRightException {
            this.value = Rfc4314Rights.flagMaskLookup(right.getValue());
        }

        public Rfc4314Rights(String serializedRfc4314Rights) throws UnsupportedRightException {
            int v = 0;
            block14: for (int i = 0; i < serializedRfc4314Rights.length(); ++i) {
                char flag = serializedRfc4314Rights.charAt(i);
                switch (flag) {
                    case 'c': {
                        switch (this.compatibilityMode) {
                            case ck_detx: {
                                v |= 8;
                                continue block14;
                            }
                            case ckx_det: {
                                v |= 8;
                                v |= 0x400;
                                continue block14;
                            }
                            case NO_COMPATIBILITY: {
                                throw new UnsupportedRightException(flag);
                            }
                        }
                        throw new IllegalStateException("Unexpected enum member: " + CompatibilityMode.class.getName() + "." + this.compatibilityMode.name());
                    }
                    case 'd': {
                        switch (this.compatibilityMode) {
                            case ck_detx: {
                                v |= 2;
                                v |= 0x100;
                                v |= 0x400;
                                continue block14;
                            }
                            case ckx_det: {
                                v |= 2;
                                v |= 0x100;
                                continue block14;
                            }
                            case NO_COMPATIBILITY: {
                                throw new UnsupportedRightException(flag);
                            }
                        }
                        throw new IllegalStateException("Unexpected enum member: " + CompatibilityMode.class.getName() + "." + this.compatibilityMode.name());
                    }
                    default: {
                        v |= Rfc4314Rights.flagMaskLookup(flag);
                    }
                }
            }
            this.value = v;
        }

        public boolean contains(char flag) throws UnsupportedRightException {
            switch (flag) {
                case 'c': {
                    switch (this.compatibilityMode) {
                        case ck_detx: {
                            return (this.value & 8) != 0;
                        }
                        case ckx_det: {
                            return (this.value & 0x408) != 0;
                        }
                        case NO_COMPATIBILITY: {
                            throw new UnsupportedRightException(flag);
                        }
                    }
                    throw new IllegalStateException("Unexpected enum member: " + CompatibilityMode.class.getName() + "." + this.compatibilityMode.name());
                }
                case 'd': {
                    switch (this.compatibilityMode) {
                        case ck_detx: {
                            return (this.value & 0x502) != 0;
                        }
                        case ckx_det: {
                            return (this.value & 0x102) != 0;
                        }
                        case NO_COMPATIBILITY: {
                            throw new UnsupportedRightException(flag);
                        }
                    }
                    throw new IllegalStateException("Unexpected enum member: " + CompatibilityMode.class.getName() + "." + this.compatibilityMode.name());
                }
            }
            return (this.value & Rfc4314Rights.flagMaskLookup(flag)) != 0;
        }

        @Override
        public boolean contains(MailboxACL.MailboxACLRight right) throws UnsupportedRightException {
            return this.contains(right.getValue());
        }

        public boolean equals(Object o) {
            if (o instanceof Rfc4314Rights) {
                return this.value == ((Rfc4314Rights)o).value;
            }
            if (o instanceof MailboxACL.MailboxACLRights) {
                try {
                    return this.value == new Rfc4314Rights((String)((MailboxACL.MailboxACLRights)o).serialize()).value;
                }
                catch (UnsupportedRightException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Override
        public MailboxACL.MailboxACLRights except(MailboxACL.MailboxACLRights toRemove) throws UnsupportedRightException {
            if (this.value == 0 || toRemove == null || toRemove.isEmpty()) {
                return this;
            }
            if (toRemove instanceof Rfc4314Rights) {
                Rfc4314Rights other = (Rfc4314Rights)toRemove;
                if (other.value == 0) {
                    return this;
                }
                return new Rfc4314Rights(this.value & ~other.value);
            }
            return new Rfc4314Rights(this.value & ~new Rfc4314Rights((String)toRemove.serialize()).value);
        }

        public int getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return this.value == 0;
        }

        @Override
        public boolean isSupported(MailboxACL.MailboxACLRight right) {
            try {
                this.contains(right.getValue());
                return true;
            }
            catch (UnsupportedRightException e) {
                return false;
            }
        }

        @Override
        public Iterator<MailboxACL.MailboxACLRight> iterator() {
            return new Rfc4314RightsIterator();
        }

        @Override
        public String serialize() {
            StringBuilder result = new StringBuilder(11);
            for (int i = 0; i < 11; ++i) {
                if ((this.value & 1 << i) == 0) continue;
                result.append(indexFlagLookup[i]);
            }
            return result.toString();
        }

        public String toString() {
            return this.serialize();
        }

        @Override
        public MailboxACL.MailboxACLRights union(MailboxACL.MailboxACLRights toAdd) throws UnsupportedRightException {
            if (this.value == 0) {
                return toAdd;
            }
            if (toAdd instanceof Rfc4314Rights) {
                Rfc4314Rights other = (Rfc4314Rights)toAdd;
                if (other.value == 0) {
                    return this;
                }
                return new Rfc4314Rights(this.value | other.value);
            }
            return new Rfc4314Rights(this.value | new Rfc4314Rights((String)toAdd.serialize()).value);
        }

        static {
            k_CreateMailbox_RIGHT = new SimpleMailboxACLRight('k');
            l_Lookup_RIGHT = new SimpleMailboxACLRight('l');
            p_Post_RIGHT = new SimpleMailboxACLRight('p');
            r_Read_RIGHT = new SimpleMailboxACLRight('r');
            s_WriteSeenFlag_RIGHT = new SimpleMailboxACLRight('s');
            t_DeleteMessages_RIGHT = new SimpleMailboxACLRight('t');
            w_Write_RIGHT = new SimpleMailboxACLRight('w');
            x_DeleteMailbox_RIGHT = new SimpleMailboxACLRight('x');
            indexFlagLookup = new char[]{'a', 'e', 'i', 'k', 'l', 'p', 'r', 's', 't', 'w', 'x'};
            indexRightLookup = new MailboxACL.MailboxACLRight[]{a_Administer_RIGHT, e_PerformExpunge_RIGHT, i_Insert_RIGHT, k_CreateMailbox_RIGHT, l_Lookup_RIGHT, p_Post_RIGHT, r_Read_RIGHT, s_WriteSeenFlag_RIGHT, t_DeleteMessages_RIGHT, w_Write_RIGHT, x_DeleteMailbox_RIGHT};
        }

        private class Rfc4314RightsIterator
        implements Iterator<MailboxACL.MailboxACLRight> {
            int position = 0;

            public Rfc4314RightsIterator() {
                this.nextPostion();
            }

            @Override
            public boolean hasNext() {
                return this.position < 11;
            }

            @Override
            public MailboxACL.MailboxACLRight next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException("No next element at position " + this.position + " from " + 11 + " in " + Rfc4314RightsIterator.class.getName());
                }
                MailboxACL.MailboxACLRight result = indexRightLookup[this.position];
                ++this.position;
                this.nextPostion();
                return result;
            }

            private void nextPostion() {
                while (this.position < 11 && (Rfc4314Rights.this.value & 1 << this.position) == 0) {
                    ++this.position;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove rights through this " + Rfc4314RightsIterator.class.getName());
            }
        }

        public static enum CompatibilityMode {
            ck_detx,
            ckx_det,
            NO_COMPATIBILITY;

        }
    }
}

