/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MimeDescriptor;

public interface MessageResult
extends Comparable<MessageResult>,
MessageMetaData {
    public MimeDescriptor getMimeDescriptor() throws MailboxException;

    public MailboxId getMailboxId();

    public Iterator<Header> iterateHeaders(MimePath var1) throws MailboxException;

    public Iterator<Header> iterateMimeHeaders(MimePath var1) throws MailboxException;

    public Content getFullContent() throws MailboxException, IOException;

    public Content getFullContent(MimePath var1) throws MailboxException;

    public Content getBody() throws MailboxException, IOException;

    public Content getBody(MimePath var1) throws MailboxException;

    public Content getMimeBody(MimePath var1) throws MailboxException;

    public Headers getHeaders() throws MailboxException;

    public List<MessageAttachment> getAttachments() throws MailboxException;

    @Override
    public MessageId getMessageId();

    public static interface MimePath {
        public int[] getPositions();
    }

    public static interface Header
    extends Content {
        public String getName() throws MailboxException;

        public String getValue() throws MailboxException;
    }

    public static interface FetchGroup {
        public static final int MINIMAL = 0;
        public static final int MIME_DESCRIPTOR = 1;
        public static final int HEADERS = 256;
        public static final int FULL_CONTENT = 512;
        public static final int BODY_CONTENT = 1024;
        public static final int MIME_HEADERS = 2048;
        public static final int MIME_CONTENT = 4096;

        public int content();

        public Set<PartContentDescriptor> getPartContentDescriptors();

        public static interface PartContentDescriptor {
            public int content();

            public MimePath path();
        }
    }
}

