/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxPath;

public final class MailboxQuery {
    private final MailboxPath base;
    private final String expression;
    private final char pathDelimiter;
    private final Pattern pattern;
    public static final char FREEWILDCARD = '*';
    public static final char LOCALWILDCARD = '%';

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MailboxSession session) {
        return MailboxQuery.builder().pathDelimiter(session.getPathDelimiter()).username(session.getUser().getUserName());
    }

    public MailboxQuery(MailboxPath base, String expression, char pathDelimiter) {
        this.base = base;
        if (base.getName() == null) {
            this.base.setName("");
        }
        this.expression = expression == null ? "" : expression;
        this.pathDelimiter = pathDelimiter;
        this.pattern = this.constructEscapedRegex();
    }

    public final MailboxPath getBase() {
        return this.base;
    }

    public final String getExpression() {
        return this.expression;
    }

    public final char getFreeWildcard() {
        return '*';
    }

    public final char getLocalWildcard() {
        return '%';
    }

    public final boolean isExpressionMatch(String name) {
        boolean result = this.isWild() ? (name == null ? false : this.pattern.matcher(name).matches()) : this.expression.equals(name);
        return result;
    }

    public String getCombinedName() {
        String result;
        if (this.base != null && this.base.getName() != null && this.base.getName().length() > 0) {
            int baseLength = this.base.getName().length();
            result = this.base.getName().charAt(baseLength - 1) == this.pathDelimiter ? (this.expression != null && this.expression.length() > 0 ? (this.expression.charAt(0) == this.pathDelimiter ? this.base.getName() + this.expression.substring(1) : this.base.getName() + this.expression) : this.base.getName()) : (this.expression != null && this.expression.length() > 0 ? (this.expression.charAt(0) == this.pathDelimiter ? this.base.getName() + this.expression : this.base.getName() + this.pathDelimiter + this.expression) : this.base.getName());
        } else {
            result = this.expression;
        }
        return result;
    }

    public boolean isWild() {
        return this.expression != null && (this.expression.indexOf(this.getFreeWildcard()) >= 0 || this.expression.indexOf(this.getLocalWildcard()) >= 0);
    }

    public String toString() {
        String TAB = " ";
        return "MailboxExpression [ base = " + this.base + " " + "expression = " + this.expression + " " + "freeWildcard = " + this.getFreeWildcard() + " " + "localWildcard = " + this.getLocalWildcard() + " " + " ]";
    }

    private Pattern constructEscapedRegex() {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(this.expression, "*%", true);
        while (tokenizer.hasMoreTokens()) {
            stringBuilder.append(this.getRegexPartAssociatedWithToken(tokenizer));
        }
        return Pattern.compile(stringBuilder.toString());
    }

    private String getRegexPartAssociatedWithToken(StringTokenizer tokenizer) {
        String token = tokenizer.nextToken();
        if (token.equals("*")) {
            return ".*";
        }
        if (token.equals("%")) {
            return "[^" + Pattern.quote(String.valueOf(this.pathDelimiter)) + "]*";
        }
        return Pattern.quote(token);
    }

    public static class Builder {
        private static final String EMPTY_PATH_NAME = "";
        private MailboxPath base;
        private String expression;
        @VisibleForTesting
        char pathDelimiter;
        @VisibleForTesting
        String username;
        @VisibleForTesting
        Optional<String> pathName = Optional.absent();
        @VisibleForTesting
        Optional<String> namespace = Optional.absent();

        private Builder() {
        }

        public Builder base(MailboxPath base) {
            this.base = base;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder privateUserMailboxes() {
            Preconditions.checkState((!this.pathName.isPresent() ? 1 : 0) != 0);
            Preconditions.checkState((!this.namespace.isPresent() ? 1 : 0) != 0);
            Preconditions.checkState((this.base == null ? 1 : 0) != 0);
            this.namespace = Optional.of((Object)"#private");
            this.pathName = Optional.of((Object)EMPTY_PATH_NAME);
            return this.matchesAll();
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder matchesAll() {
            this.expression = String.valueOf('*');
            return this;
        }

        public Builder pathDelimiter(char pathDelimiter) {
            this.pathDelimiter = pathDelimiter;
            return this;
        }

        public MailboxQuery build() {
            Preconditions.checkState((this.base != null || this.username != null ? 1 : 0) != 0);
            if (this.base != null && this.username != null) {
                throw new IllegalStateException("'base' and 'username' are exclusives");
            }
            return new MailboxQuery(this.buildBase(), this.expression, this.pathDelimiter);
        }

        private MailboxPath buildBase() {
            if (this.base != null) {
                return this.base;
            }
            return new MailboxPath((String)this.namespace.or((Object)"#private"), this.username, (String)this.pathName.or((Object)EMPTY_PATH_NAME));
        }
    }
}

