/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Map;
import org.apache.james.mailbox.exception.UnsupportedRightException;

public interface MailboxACL {
    public static final char ADD_RIGHTS_MARKER = '+';
    public static final char DEFAULT_GROUP_MARKER = '$';
    public static final char DEFAULT_NEGATIVE_MARKER = '-';
    public static final char REMOVE_RIGHTS_MARKER = '-';

    public MailboxACL apply(MailboxACLCommand var1) throws UnsupportedRightException;

    public MailboxACL except(MailboxACL var1) throws UnsupportedRightException;

    public MailboxACL except(MailboxACLEntryKey var1, MailboxACLRights var2) throws UnsupportedRightException;

    public Map<MailboxACLEntryKey, MailboxACLRights> getEntries();

    public MailboxACL replace(MailboxACLEntryKey var1, MailboxACLRights var2) throws UnsupportedRightException;

    public MailboxACL union(MailboxACL var1) throws UnsupportedRightException;

    public MailboxACL union(MailboxACLEntryKey var1, MailboxACLRights var2) throws UnsupportedRightException;

    public static enum SpecialName {
        anybody,
        authenticated,
        owner;

    }

    public static enum NameType {
        group,
        special,
        user;

    }

    public static interface MailboxACLCommand {
        public MailboxACLEntryKey getEntryKey();

        public EditMode getEditMode();

        public MailboxACLRights getRights();
    }

    public static interface MailboxACLRights
    extends Iterable<MailboxACLRight> {
        public boolean contains(MailboxACLRight var1) throws UnsupportedRightException;

        public MailboxACLRights except(MailboxACLRights var1) throws UnsupportedRightException;

        public boolean isEmpty();

        public boolean isSupported(MailboxACLRight var1);

        public String serialize();

        public MailboxACLRights union(MailboxACLRights var1) throws UnsupportedRightException;
    }

    public static interface MailboxACLRight {
        public char getValue();
    }

    public static interface MailboxACLEntryKey {
        public String getName();

        public NameType getNameType();

        public boolean isNegative();

        public String serialize();
    }

    public static enum EditMode {
        ADD,
        REMOVE,
        REPLACE;

    }
}

