/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class Cid {
    private final String value;

    public static Cid from(String cidAsString) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)cidAsString) ? 1 : 0) != 0, (Object)"'cidAsString' is mandatory");
        return new Cid(Cid.normalizedCid(cidAsString));
    }

    private static String normalizedCid(String input) {
        if (Cid.isWrappedWithAngleBrackets(input)) {
            return Cid.unwrap(input);
        }
        return input;
    }

    private static String unwrap(String cidAsString) {
        String unwrapCid = cidAsString.substring(1, cidAsString.length() - 1);
        if (StringUtils.isBlank((String)unwrapCid)) {
            throw new IllegalArgumentException("'cidAsString' is mandatory");
        }
        return unwrapCid;
    }

    private static boolean isWrappedWithAngleBrackets(String cidAsString) {
        return cidAsString.startsWith("<") && cidAsString.endsWith(">");
    }

    private Cid(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Cid) {
            Cid other = (Cid)obj;
            return Objects.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

